/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.HashMap;

public class DIGDataTypes {
    public static final int REAL_MULTIPLIER = 10000;
    private static DIGDataTypes instance;
    private HashMap map = new HashMap();
    private HashMap rangeMap;

    protected DIGDataTypes(OWLModel owlModel) {
        this.map.put(owlModel.getXSDint(), new IntDataTypeMapEntry());
        this.map.put(owlModel.getXSDinteger(), new IntDataTypeMapEntry());
        this.map.put(owlModel.getXSDlong(), new IntDataTypeMapEntry());
        this.map.put(owlModel.getXSDshort(), new IntDataTypeMapEntry());
        this.map.put(owlModel.getXSDboolean(), new IntDataTypeMapEntry());
        this.map.put(owlModel.getXSDstring(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDtime(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDanyURI(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDbase64Binary(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDdecimal(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDbyte(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDdouble(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDduration(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDdateTime(), new StringDataTypeMapEntry());
        this.map.put(owlModel.getXSDdate(), new StringDataTypeMapEntry());
    }

    public static synchronized DIGDataTypes getInstance(OWLModel owlModel) {
        if (instance == null) {
            instance = new DIGDataTypes(owlModel);
        }
        return instance;
    }

    public boolean isSupported(RDFSDatatype datatype) {
        return this.map.containsKey(datatype);
    }

    public boolean isSupported(RDFSLiteral value) {
        return this.map.containsKey(value.getDatatype());
    }

    public String getIndividualAxiomValueTagName(RDFSLiteral value) {
        String ret = null;
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(value.getDatatype());
        if (dataTypeMapEntry != null) {
            ret = dataTypeMapEntry.getValueTag();
        }
        return ret;
    }

    public String getPropertyRangeTagName(RDFSDatatype datatype) {
        String ret = null;
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(datatype);
        if (dataTypeMapEntry != null) {
            ret = dataTypeMapEntry.getRangeTag();
        }
        return ret;
    }

    public String getConcreteDomainExpressionTagName(RDFSLiteral value) {
        String ret = null;
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(value.getDatatype());
        if (dataTypeMapEntry != null) {
            ret = dataTypeMapEntry.getValueRestrictionTag();
        }
        return ret;
    }

    public String getDataTypeRendering(RDFSLiteral value) {
        DataTypeMapEntry dataTypeMapEntry = (DataTypeMapEntry)this.map.get(value.getDatatype());
        if (dataTypeMapEntry != null) {
            return dataTypeMapEntry.getRenderering(value);
        }
        return null;
    }

    private abstract class DataTypeMapEntry {
        private String valueTag;
        private String rangeTag;
        private String valueRestrictionTag;

        public DataTypeMapEntry(String valueTag, String rangeTag, String valueRestrictionTag) {
            this.valueTag = valueTag;
            this.rangeTag = rangeTag;
            this.valueRestrictionTag = valueRestrictionTag;
        }

        public String getValueTag() {
            return this.valueTag;
        }

        public String getRangeTag() {
            return this.rangeTag;
        }

        public String getValueRestrictionTag() {
            return this.valueRestrictionTag;
        }

        public abstract String getRenderering(RDFSLiteral var1);
    }

    private class IntDataTypeMapEntry
    extends DataTypeMapEntry {
        public IntDataTypeMapEntry() {
            super("ival", "rangeint", "intequals");
        }

        public String getRenderering(RDFSLiteral value) {
            return value.getString();
        }
    }

    private class StringDataTypeMapEntry
    extends DataTypeMapEntry {
        public StringDataTypeMapEntry() {
            super("sval", "rangestring", "stringequals");
        }

        public String getRenderering(RDFSLiteral value) {
            return value.getString();
        }
    }
}

