/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskEvent;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTaskListener;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ResetInferredHierarchyTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateEquivalentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInconsistentClassesTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.UpdateInferredHierarchyTask;

public class ClassifyTaxonomyTask
extends AbstractReasonerTask
implements ReasonerTaskListener {
    private ResetInferredHierarchyTask resetInferredHierarchyTask;
    private UpdateInconsistentClassesTask inconsistentClassesTask;
    private UpdateInferredHierarchyTask inferredHierarchyTask;
    private UpdateEquivalentClassesTask equivalentClassesTask;

    public ClassifyTaxonomyTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.resetInferredHierarchyTask = new ResetInferredHierarchyTask(protegeOWLReasoner);
        this.resetInferredHierarchyTask.addTaskListener(this);
        this.inconsistentClassesTask = new UpdateInconsistentClassesTask(protegeOWLReasoner);
        this.inconsistentClassesTask.addTaskListener(this);
        this.inferredHierarchyTask = new UpdateInferredHierarchyTask(protegeOWLReasoner);
        this.inferredHierarchyTask.addTaskListener(this);
        this.equivalentClassesTask = new UpdateEquivalentClassesTask(protegeOWLReasoner);
        this.equivalentClassesTask.addTaskListener(this);
    }

    public int getTaskSize() {
        int taskSize = this.resetInferredHierarchyTask.getTaskSize() + this.inconsistentClassesTask.getTaskSize() + this.inferredHierarchyTask.getTaskSize() + this.equivalentClassesTask.getTaskSize();
        return taskSize;
    }

    public void run() throws DIGReasonerException {
        this.setProgress(0);
        this.doAbortCheck();
        this.resetInferredHierarchyTask.run();
        this.doAbortCheck();
        this.inconsistentClassesTask.run();
        this.doAbortCheck();
        this.inferredHierarchyTask.run();
        this.doAbortCheck();
        this.equivalentClassesTask.run();
        this.setDescription("Finished");
        this.setMessage("Classification complete");
        this.setTaskCompleted();
    }

    public void progressChanged(ReasonerTaskEvent event) {
        int progress = this.resetInferredHierarchyTask.getProgress() + this.inconsistentClassesTask.getProgress() + this.inferredHierarchyTask.getProgress() + this.equivalentClassesTask.getProgress();
        this.setProgress(progress);
    }

    public void progressIndeterminateChanged(ReasonerTaskEvent event) {
        this.setProgressIndeterminate(event.getSource().isProgressIndeterminate());
    }

    public void descriptionChanged(ReasonerTaskEvent event) {
        this.setDescription(event.getSource().getDescription());
    }

    public void messageChanged(ReasonerTaskEvent event) {
        this.setMessage(event.getSource().getMessage());
    }

    public void taskFailed(ReasonerTaskEvent event) {
        this.setMessage(event.getSource().getMessage());
    }

    public void taskCompleted(ReasonerTaskEvent event) {
    }

    public void addedToTask(ReasonerTaskEvent event) {
    }

    public void setRequestAbort() {
        super.setRequestAbort();
        this.resetInferredHierarchyTask.setRequestAbort();
        this.inconsistentClassesTask.setRequestAbort();
        this.inferredHierarchyTask.setRequestAbort();
        this.equivalentClassesTask.setRequestAbort();
    }
}

