/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateEquivalentClassesTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateEquivalentClassesTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecord parentRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Compute equivalent classes", null);
        this.doAbortCheck();
        this.postLogRecord(parentRecord);
        TimeDifference td = new TimeDifference();
        this.setProgress(0);
        this.setDescription("Computing equivalent classes");
        this.setMessage("Building equivalent classes reasoner query...");
        td.markStart();
        Document asksDoc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        Collection namedClses = ReasonerUtil.getInstance().getNamedClses(kb);
        for (OWLNamedClass curNamedCls : namedClses) {
            this.getTranslator().createEquivalentConceptsQuery(asksDoc, curNamedCls.getName(), curNamedCls);
        }
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to build query = " + td, parentRecord));
        this.doAbortCheck();
        this.setMessage("Querying reasoner...");
        td.markStart();
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(asksDoc);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to query reasoner = " + td, parentRecord));
        this.doAbortCheck();
        this.setMessage("Updating Protege-OWL...");
        td.markStart();
        kb.setGenerateEventsEnabled(false);
        kb.beginTransaction("Compute and update equivalent classes");
        Iterator responseIt = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        while (responseIt.hasNext()) {
            this.doAbortCheck();
            DIGQueryResponse response = (DIGQueryResponse)responseIt.next();
            String curQueryID = response.getID();
            OWLNamedClass curNamedCls = kb.getOWLNamedClass(curQueryID);
            if (curNamedCls != null && curNamedCls.isConsistent()) {
                for (OWLNamedClass curSuperCls : response.getConcepts()) {
                    if (curSuperCls.equals(curNamedCls)) continue;
                    if (!curNamedCls.getInferredSuperclasses().contains(curSuperCls)) {
                        curNamedCls.addInferredSuperclass(curSuperCls);
                    }
                    if (curSuperCls.getInferredSuperclasses().contains(curNamedCls)) continue;
                    curSuperCls.addInferredSuperclass(curNamedCls);
                }
            }
            this.setProgress(this.getProgress() + 1);
        }
        kb.endTransaction();
        kb.setGenerateEventsEnabled(true);
        td.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + td, parentRecord));
        this.setTaskCompleted();
    }
}

