/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.ui;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordRenderer;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.ReasonerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ReasonerProgressModalDialog
extends JDialog {
    private JButton okButton;
    private JButton cancelButton;
    private JProgressBar progBar;
    private JLabel messageLabel;
    private String description;
    private String message;
    private JTree tree;
    private DefaultMutableTreeNode root;
    private HashMap treeNodeMap;
    private ReasonerTask curTask;

    public ReasonerProgressModalDialog(Frame owner, String title) {
        super(owner, title, true);
        this.setDefaultCloseOperation(2);
        this.setSize(600, 500);
        this.setLocation(this.getToolkit().getScreenSize().width / 2 - this.getWidth() / 2, this.getToolkit().getScreenSize().height / 2 - this.getHeight() / 2);
        this.createUI();
    }

    private void createUI() {
        JPanel panel = new JPanel(new BorderLayout(7, 7));
        this.getContentPane().setLayout(new BorderLayout());
        this.createLogRecordTree(panel);
        this.createProgressPanel(panel);
        this.createButtonPanel(panel);
        this.getContentPane().add(panel);
        this.setupKeyClose();
    }

    private void createLogRecordTree(JPanel parentPanel) {
        this.treeNodeMap = new HashMap();
        this.root = new DefaultMutableTreeNode("Reasoner log");
        this.tree = new JTree(new DefaultTreeModel(this.root));
        parentPanel.add(new JScrollPane(this.tree));
        this.tree.setCellRenderer(new ReasonerLogRecordRenderer());
        this.tree.setRowHeight(0);
    }

    private void createProgressPanel(JPanel parentPanel) {
        JPanel pan = new JPanel(new BorderLayout(7, 7));
        this.messageLabel = new JLabel();
        pan.add((Component)this.messageLabel, "North");
        this.progBar = new JProgressBar();
        pan.add((Component)this.progBar, "South");
        parentPanel.add((Component)pan, "North");
    }

    private void createButtonPanel(JPanel parentPanel) {
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReasonerProgressModalDialog.this.closeDialog();
            }
        });
        this.okButton.setDefaultCapable(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ReasonerProgressModalDialog.this.curTask != null) {
                    ReasonerProgressModalDialog.this.curTask.setRequestAbort();
                }
                ReasonerProgressModalDialog.this.cancelButton.setEnabled(false);
            }
        });
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 7, 7));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.okButton);
        JPanel buttonPanelHolder = new JPanel(new BorderLayout());
        buttonPanelHolder.add((Component)buttonPanel, "East");
        parentPanel.add((Component)buttonPanelHolder, "South");
        parentPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
    }

    private void setupKeyClose() {
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ReasonerProgressModalDialog.this.closeDialog();
                }
            }
        });
    }

    public void setMessage(String message) {
        this.message = message;
        this.updateLabel();
    }

    public void setDescription(String description) {
        this.description = description;
        this.updateLabel();
    }

    protected void updateLabel() {
        this.messageLabel.setText(String.valueOf(this.description) + ": " + this.message);
    }

    public void setOKButtonEnabled(boolean b) {
        this.okButton.setEnabled(b);
    }

    public void setCancelButtonEnabled(boolean b) {
        this.cancelButton.setEnabled(b);
    }

    public void setProgressBarMaxValue(int value) {
        this.progBar.setMaximum(value);
    }

    public void setProgress(int progress) {
        if (this.progBar.isIndeterminate()) {
            this.progBar.setIndeterminate(false);
        }
        this.progBar.setValue(progress);
    }

    public void setProgressIndeterminate(boolean b) {
        this.progBar.setIndeterminate(b);
    }

    public void postLogRecord(ReasonerLogRecord logRecord) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(logRecord);
        this.treeNodeMap.put(logRecord, node);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.treeNodeMap.get(logRecord.getParent());
        if (parentNode == null) {
            parentNode = this.root;
        }
        model.insertNodeInto(node, parentNode, parentNode.getChildCount());
        this.tree.expandPath(new TreePath(parentNode.getPath()));
        this.tree.scrollPathToVisible(new TreePath(this.root.getLastLeaf().getPath()));
        this.tree.updateUI();
    }

    public void setReasonerDescription(String description) {
        this.setTitle(description);
    }

    public void setTask(ReasonerTask task) {
        this.curTask = task;
    }

    private void closeDialog() {
        if (this.okButton.isEnabled()) {
            this.treeNodeMap.keySet().removeAll(this.treeNodeMap.keySet());
            this.root.removeAllChildren();
            this.dispose();
        }
    }
}

