/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.util.Iterator;

public class CreatePropertiesTestCase
extends AbstractJenaCreatorTestCase {
    public void testCreateSimpleRDFProperty() {
        RDFProperty slot = this.owlModel.createRDFProperty("slot");
        String uri = slot.getURI();
        OntModel newModel = this.runJenaCreator();
        OntProperty property = newModel.getOntProperty(uri);
        CreatePropertiesTestCase.assertNotNull((Object)property);
        CreatePropertiesTestCase.assertEquals((Object)RDF.Property, (Object)property.getRDFType());
    }

    public void testCreateSimpleDatatypeProperty() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        String uri = slot.getURI();
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty property = newModel.getDatatypeProperty(uri);
        CreatePropertiesTestCase.assertNotNull((Object)property);
        CreatePropertiesTestCase.assertEquals((Object)OWL.DatatypeProperty, (Object)property.getRDFType());
    }

    public void testCreateSimpleObjectProperty() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        String uri = slot.getURI();
        OntModel newModel = this.runJenaCreator();
        ObjectProperty property = newModel.getObjectProperty(uri);
        CreatePropertiesTestCase.assertNotNull((Object)property);
        CreatePropertiesTestCase.assertEquals((Object)OWL.ObjectProperty, (Object)property.getRDFType());
    }

    public void testDatatypePropertyWithNoRange() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", (RDFSDatatype)null);
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        slot.addUnionDomainClass(cls);
        RDFResource instance = cls.createInstance("instance");
        instance.addPropertyValue(slot, Boolean.TRUE);
        instance.addPropertyValue(slot, new Float(4.2));
        instance.addPropertyValue(slot, new Integer(42));
        instance.addPropertyValue(slot, "Holgi");
        CreatePropertiesTestCase.assertSize(4, instance.getPropertyValues(slot, true));
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty property = newModel.getDatatypeProperty(slot.getURI());
        CreatePropertiesTestCase.assertNull((Object)property.getRange());
        Individual individual = newModel.getIndividual(instance.getURI());
        CreatePropertiesTestCase.assertSize(4, (Iterator)individual.listPropertyValues((Property)property));
        CreatePropertiesTestCase.assertHasValue((OntResource)individual, (OntProperty)property, ValueType.BOOLEAN, Boolean.TRUE);
        CreatePropertiesTestCase.assertHasValue((OntResource)individual, (OntProperty)property, ValueType.FLOAT, new Float(4.2));
        CreatePropertiesTestCase.assertHasValue((OntResource)individual, (OntProperty)property, ValueType.INTEGER, new Integer(42));
        CreatePropertiesTestCase.assertHasValue((OntResource)individual, (OntProperty)property, ValueType.STRING, "Holgi");
    }

    public void testEquivalentProperties() {
        OWLObjectProperty equivalentSlot = this.owlModel.createOWLObjectProperty("equivalent");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.addEquivalentProperty(equivalentSlot);
        OntModel newModel = this.runJenaCreator();
        ObjectProperty equivalentProperty = newModel.getObjectProperty(equivalentSlot.getURI());
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        CreatePropertiesTestCase.assertEquals((Object)equivalentProperty, (Object)property.getEquivalentProperty());
    }

    public void testFunctionalProperty() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        slot.setFunctional(true);
        OWLDatatypeProperty other = this.owlModel.createOWLDatatypeProperty("other", this.owlModel.getXSDstring());
        other.setFunctional(false);
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty property = newModel.getDatatypeProperty(slot.getURI());
        CreatePropertiesTestCase.assertTrue((boolean)property.hasRDFType(OWL.FunctionalProperty));
        DatatypeProperty otherProperty = newModel.getDatatypeProperty(other.getURI());
        CreatePropertiesTestCase.assertFalse((boolean)otherProperty.hasRDFType(OWL.FunctionalProperty));
    }

    public void testInverseProperty() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLObjectProperty inverseSlot = this.owlModel.createOWLObjectProperty("inverse");
        slot.setInverseProperty(inverseSlot);
        OntModel newModel = this.runJenaCreator();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        ObjectProperty inverseProperty = newModel.getObjectProperty(inverseSlot.getURI());
        CreatePropertiesTestCase.assertNotNull((Object)property);
        CreatePropertiesTestCase.assertNotNull((Object)inverseProperty);
        CreatePropertiesTestCase.assertTrue((boolean)property.hasInverse());
        CreatePropertiesTestCase.assertEquals((Object)inverseProperty, (Object)property.getInverse());
    }

    public void testInverseFunctionalProperty() {
        OWLDatatypeProperty slot = this.owlModel.createOWLDatatypeProperty("slot", this.owlModel.getXSDstring());
        slot.setInverseFunctional(true);
        OWLDatatypeProperty other = this.owlModel.createOWLDatatypeProperty("other", this.owlModel.getXSDstring());
        other.setInverseFunctional(false);
        OntModel newModel = this.runJenaCreator();
        DatatypeProperty property = newModel.getDatatypeProperty(slot.getURI());
        CreatePropertiesTestCase.assertTrue((boolean)property.hasRDFType(OWL.InverseFunctionalProperty));
        DatatypeProperty otherProperty = newModel.getDatatypeProperty(other.getURI());
        CreatePropertiesTestCase.assertFalse((boolean)otherProperty.hasRDFType(OWL.InverseFunctionalProperty));
    }

    public void testSuperProperties() {
        OWLObjectProperty superSlot = this.owlModel.createOWLObjectProperty("super");
        OWLObjectProperty subSlot = this.owlModel.createOWLObjectProperty("sub");
        subSlot.addSuperproperty(superSlot);
        OntModel newModel = this.runJenaCreator();
        ObjectProperty superProperty = newModel.getObjectProperty(superSlot.getURI());
        ObjectProperty subProperty = newModel.getObjectProperty(subSlot.getURI());
        CreatePropertiesTestCase.assertEquals((Object)subProperty, (Object)superProperty.getSubProperty());
        CreatePropertiesTestCase.assertEquals((Object)superProperty, (Object)subProperty.getSuperProperty());
    }

    public void testSymmetricProperty() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setSymmetric(true);
        OWLObjectProperty other = this.owlModel.createOWLObjectProperty("other");
        other.setSymmetric(false);
        OntModel newModel = this.runJenaCreator();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        CreatePropertiesTestCase.assertTrue((boolean)property.hasRDFType(OWL.SymmetricProperty));
        ObjectProperty otherProperty = newModel.getObjectProperty(other.getURI());
        CreatePropertiesTestCase.assertFalse((boolean)otherProperty.hasRDFType(OWL.SymmetricProperty));
    }

    public void testTransitiveProperty() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setTransitive(true);
        OWLObjectProperty other = this.owlModel.createOWLObjectProperty("other");
        other.setTransitive(false);
        OntModel newModel = this.runJenaCreator();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        CreatePropertiesTestCase.assertTrue((boolean)property.hasRDFType(OWL.TransitiveProperty));
        ObjectProperty otherProperty = newModel.getObjectProperty(other.getURI());
        CreatePropertiesTestCase.assertFalse((boolean)otherProperty.hasRDFType(OWL.TransitiveProperty));
    }

    public void testDomainlessPropertyValues() {
        OWLNamedClass wordClass = this.owlModel.createOWLNamedClass("Word");
        OWLDatatypeProperty nameprop = this.owlModel.createOWLDatatypeProperty("name");
        wordClass.createOWLIndividual("thing").setPropertyValue(nameprop, "something");
        wordClass.setPropertyValue(nameprop, "some");
        OntModel ontModel = this.runJenaCreator();
        OntClass wordOntClass = ontModel.getOntClass(wordClass.getURI());
        OntProperty property = ontModel.getOntProperty(nameprop.getURI());
        CreatePropertiesTestCase.assertNotNull((Object)property);
        CreatePropertiesTestCase.assertSize(1, (Iterator)wordOntClass.listPropertyValues((Property)property));
    }
}

