/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegeGraph;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import java.util.ArrayList;
import java.util.Iterator;

public class JenaModelFactory {
    public static Model createModel(OWLModel owlModel) {
        TripleStoreModel tsm = owlModel.getTripleStoreModel();
        if (tsm.getTripleStores().size() == 2) {
            TripleStore ts = tsm.getTopTripleStore();
            ProtegeGraph graph = new ProtegeGraph(owlModel, ts);
            return ModelFactory.createModelForGraph((Graph)graph);
        }
        ArrayList<ProtegeGraph> graphs = new ArrayList<ProtegeGraph>();
        Iterator it = tsm.listUserTripleStores();
        while (it.hasNext()) {
            TripleStore ts = (TripleStore)it.next();
            ProtegeGraph graph = new ProtegeGraph(owlModel, ts);
            graphs.add(graph);
        }
        MultiUnion unionGraph = new MultiUnion(graphs.iterator());
        return ModelFactory.createModelForGraph((Graph)unionGraph);
    }
}

