/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class LoadKoalaTestCase
extends AbstractJenaTestCase {
    public void testLoadKoala() throws Exception {
        this.loadRemoteOntology("koala.owl");
        OWLObjectProperty hasChildrenSlot = this.owlModel.getOWLObjectProperty("hasChildren");
        OWLObjectProperty hasDegreeSlot = this.owlModel.getOWLObjectProperty("hasDegree");
        OWLObjectProperty hasGenderSlot = this.owlModel.getOWLObjectProperty("hasGender");
        OWLObjectProperty hasHabitatSlot = this.owlModel.getOWLObjectProperty("hasHabitat");
        OWLDatatypeProperty isHardWorkingSlot = this.owlModel.getOWLDatatypeProperty("isHardWorking");
        OWLNamedClass femaleCls = this.owlModel.getOWLNamedClass("Female");
        OWLNamedClass genderCls = this.owlModel.getOWLNamedClass("Gender");
        OWLNamedClass animalCls = this.owlModel.getOWLNamedClass("Animal");
        OWLNamedClass marsupialsCls = this.owlModel.getOWLNamedClass("Marsupials");
        OWLNamedClass koalaCls = this.owlModel.getOWLNamedClass("Koala");
        OWLNamedClass koalaWithPhDCls = this.owlModel.getOWLNamedClass("KoalaWithPhD");
        OWLNamedClass quokkaCls = this.owlModel.getOWLNamedClass("Quokka");
        OWLNamedClass tasmanianDevilCls = this.owlModel.getOWLNamedClass("TasmanianDevil");
        OWLNamedClass parentCls = this.owlModel.getOWLNamedClass("Parent");
        OWLNamedClass personCls = this.owlModel.getOWLNamedClass("Person");
        OWLNamedClass studentCls = this.owlModel.getOWLNamedClass("Student");
        OWLNamedClass graduateStudentCls = this.owlModel.getOWLNamedClass("GraduateStudent");
        OWLNamedClass maleStudentWith3DaughtersCls = this.owlModel.getOWLNamedClass("MaleStudentWith3Daughters");
        OWLNamedClass habitatCls = this.owlModel.getOWLNamedClass("Habitat");
        OWLNamedClass forestCls = this.owlModel.getOWLNamedClass("Forest");
        OWLNamedClass dryEucalypForestCls = this.owlModel.getOWLNamedClass("DryEucalyptForest");
        OWLNamedClass rainforestCls = this.owlModel.getOWLNamedClass("Rainforest");
        OWLNamedClass universityCls = this.owlModel.getOWLNamedClass("University");
        OWLNamedClass degreeCls = this.owlModel.getOWLNamedClass("Degree");
        OWLNamedClass maleCls = this.owlModel.getOWLNamedClass("Male");
        Instance femaleInstance = this.owlModel.getInstance("female");
        Instance maleInstance = this.owlModel.getInstance("male");
        Instance baInstance = this.owlModel.getInstance("BA");
        Instance bsInstance = this.owlModel.getInstance("BS");
        Instance maInstance = this.owlModel.getInstance("MA");
        Instance phdInstance = this.owlModel.getInstance("PhD");
        LoadKoalaTestCase.assertNotNull((Object)hasChildrenSlot);
        LoadKoalaTestCase.assertNotNull((Object)hasDegreeSlot);
        LoadKoalaTestCase.assertNotNull((Object)hasGenderSlot);
        LoadKoalaTestCase.assertNotNull((Object)hasHabitatSlot);
        LoadKoalaTestCase.assertNotNull((Object)isHardWorkingSlot);
        LoadKoalaTestCase.assertNotNull((Object)femaleCls);
        LoadKoalaTestCase.assertNotNull((Object)genderCls);
        LoadKoalaTestCase.assertNotNull((Object)animalCls);
        LoadKoalaTestCase.assertNotNull((Object)marsupialsCls);
        LoadKoalaTestCase.assertNotNull((Object)koalaCls);
        LoadKoalaTestCase.assertNotNull((Object)koalaWithPhDCls);
        LoadKoalaTestCase.assertNotNull((Object)quokkaCls);
        LoadKoalaTestCase.assertNotNull((Object)tasmanianDevilCls);
        LoadKoalaTestCase.assertNotNull((Object)parentCls);
        LoadKoalaTestCase.assertNotNull((Object)personCls);
        LoadKoalaTestCase.assertNotNull((Object)studentCls);
        LoadKoalaTestCase.assertNotNull((Object)graduateStudentCls);
        LoadKoalaTestCase.assertNotNull((Object)maleStudentWith3DaughtersCls);
        LoadKoalaTestCase.assertNotNull((Object)habitatCls);
        LoadKoalaTestCase.assertNotNull((Object)forestCls);
        LoadKoalaTestCase.assertNotNull((Object)dryEucalypForestCls);
        LoadKoalaTestCase.assertNotNull((Object)rainforestCls);
        LoadKoalaTestCase.assertNotNull((Object)universityCls);
        LoadKoalaTestCase.assertNotNull((Object)degreeCls);
        LoadKoalaTestCase.assertNotNull((Object)maleCls);
        LoadKoalaTestCase.assertNotNull((Object)femaleInstance);
        LoadKoalaTestCase.assertNotNull((Object)maleInstance);
        LoadKoalaTestCase.assertNotNull((Object)baInstance);
        LoadKoalaTestCase.assertNotNull((Object)bsInstance);
        LoadKoalaTestCase.assertNotNull((Object)maInstance);
        LoadKoalaTestCase.assertNotNull((Object)phdInstance);
        this.assertHasDirectSuperclass(femaleCls, "hasGender has female");
        this.assertHasDirectSuperclass(animalCls, "hasGender exactly 1");
        this.assertHasDirectSuperclass(animalCls, "hasHabitat min 1");
        this.assertHasDirectSuperclass(koalaCls, "hasHabitat some DryEucalyptForest");
        this.assertHasDirectSuperclass(koalaCls, "isHardWorking has false");
        this.assertHasDirectDefinitionCls(koalaWithPhDCls, "hasDegree has PhD");
        this.assertHasDirectSuperclass(quokkaCls, "isHardWorking has true");
        this.assertHasDirectDefinitionCls(parentCls, "hasChildren min 1");
        this.assertHasDirectDefinitionCls(studentCls, "hasHabitat some University");
        this.assertHasDirectDefinitionCls(studentCls, "isHardWorking has true");
        this.assertHasDirectSuperclass(graduateStudentCls, "hasDegree some {BA BS}");
        this.assertHasDirectSuperclass(maleCls, "hasGender has male");
        LoadKoalaTestCase.assertEquals((Object)"1.1", (Object)animalCls.getPropertyValue(this.owlModel.getOWLVersionInfoProperty()));
    }

    private void assertHasDirectSuperclass(RDFSNamedClass aClass, String expression) {
        for (Cls superCls : aClass.getSuperclasses(false)) {
            String browserText = superCls.getBrowserText();
            if (!expression.equals(browserText)) continue;
            return;
        }
        System.err.println("Superclasses of " + aClass.getBrowserText() + ":");
        for (Cls cls : aClass.getSuperclasses(false)) {
            System.out.println("- " + cls.getBrowserText());
        }
        LoadKoalaTestCase.assertTrue((String)(String.valueOf(aClass.getBrowserText()) + " does not have superclass " + expression), (boolean)false);
    }

    private void assertHasDirectDefinitionCls(OWLNamedClass cls, String expression) {
        OWLIntersectionClass intersectionCls = (OWLIntersectionClass)cls.getEquivalentClasses().iterator().next();
        for (Cls superCls : intersectionCls.getOperands()) {
            String browserText = superCls.getBrowserText();
            if (!expression.equals(browserText)) continue;
            return;
        }
        LoadKoalaTestCase.assertTrue((String)(String.valueOf(cls.getBrowserText()) + " does not have definition class " + expression), (boolean)false);
    }
}

