/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protegex.owl.jena.protege2jena.Protege2Jena;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;
import java.util.Collection;

public class LoadRDFPropertiesTestCase
extends AbstractJenaTestCase {
    public void testLoadRDFProperty() throws Exception {
        this.loadRemoteOntology("rdfSlotTypes.owl");
        RDFProperty anyProperty = this.owlModel.getRDFProperty("anySlot");
        LoadRDFPropertiesTestCase.assertNull((Object)anyProperty.getRange());
        RDFProperty booleanProperty = this.owlModel.getRDFProperty("booleanSlot");
        LoadRDFPropertiesTestCase.assertEquals((Object)this.owlModel.getXSDboolean(), (Object)booleanProperty.getRange());
        RDFProperty stringProperty = this.owlModel.getRDFProperty("stringSlot");
        LoadRDFPropertiesTestCase.assertEquals((Object)this.owlModel.getXSDstring(), (Object)stringProperty.getRange());
        RDFProperty objectProperty = this.owlModel.getRDFProperty("objectSlot");
        LoadRDFPropertiesTestCase.assertTrue((boolean)objectProperty.hasObjectRange());
        LoadRDFPropertiesTestCase.assertSize(1, objectProperty.getUnionRangeClasses());
        LoadRDFPropertiesTestCase.assertEquals((Object)this.owlModel.getCls("Cls"), objectProperty.getUnionRangeClasses().iterator().next());
    }

    public void testLoadAnnotationProperties() throws Exception {
    }

    public void testLoadFunctionalProperties() throws Exception {
        this.loadTestOntology(new URI("http://www.owl-ontologies.com/travel.owl"));
        RDFProperty hasCityProperty = this.owlModel.getRDFProperty("hasCity");
        Collection types = hasCityProperty.getProtegeTypes();
        LoadRDFPropertiesTestCase.assertSize(2, types);
        LoadRDFPropertiesTestCase.assertContains((Object)this.owlModel.getOWLFunctionalPropertyClass(), types);
        LoadRDFPropertiesTestCase.assertContains((Object)this.owlModel.getOWLDatatypePropertyClass(), types);
        LoadRDFPropertiesTestCase.assertEquals((Object)this.owlModel.getOWLDatatypePropertyClass(), types.iterator().next());
        LoadRDFPropertiesTestCase.assertTrue((boolean)(hasCityProperty instanceof OWLDatatypeProperty));
        OWLNamedClass contactClass = this.owlModel.getOWLNamedClass("Contact");
        Collection properties = contactClass.getUnionDomainProperties();
        LoadRDFPropertiesTestCase.assertSize(4, properties);
        for (RDFProperty property : properties) {
            LoadRDFPropertiesTestCase.assertTrue((boolean)(property instanceof OWLDatatypeProperty));
        }
        Protege2Jena.createOntModel(this.owlModel);
    }
}

