/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import java.util.Iterator;

public class CreatePropertyDomainTestCase
extends AbstractProtege2JenaTestCase {
    public void testDomainSingleClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setDomainDefined(true);
        slot.addUnionDomainClass(cls);
        OntModel newModel = this.createOntModel();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        CreatePropertyDomainTestCase.assertEquals((Object)newModel.getOntClass(cls.getURI()), (Object)property.getDomain());
    }

    public void testDomainTwoClasses() {
        OWLNamedClass clsA = this.owlModel.createOWLNamedClass("ClsA");
        OWLNamedClass clsB = this.owlModel.createOWLNamedClass("ClsB");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setDomainDefined(true);
        slot.addUnionDomainClass(clsA);
        slot.addUnionDomainClass(clsB);
        OntModel newModel = this.createOntModel();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        CreatePropertyDomainTestCase.assertSize(1, (Iterator)property.listDomain());
        CreatePropertyDomainTestCase.assertTrue((boolean)property.getDomain().canAs(UnionClass.class));
        UnionClass unionClass = (UnionClass)property.getDomain().as(UnionClass.class);
        ExtendedIterator it = unionClass.listOperands();
        CreatePropertyDomainTestCase.assertEquals((Object)newModel.getOntClass(clsA.getURI()), it.next());
        CreatePropertyDomainTestCase.assertEquals((Object)newModel.getOntClass(clsB.getURI()), it.next());
        CreatePropertyDomainTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testDomainUnrestricted() {
        OWLObjectProperty owlProperty = this.owlModel.createOWLObjectProperty("owlProperty");
        owlProperty.setDomainDefined(false);
        OntModel newModel = this.createOntModel();
        ObjectProperty ontProperty = newModel.getObjectProperty(owlProperty.getURI());
        CreatePropertyDomainTestCase.assertEquals(null, (Object)ontProperty.getDomain());
    }

    public void testDomainAtRestriction() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        slot.setDomainDefined(true);
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(slot, 1));
        slot.addUnionDomainClass(cls);
        OntModel newModel = this.createOntModel();
        ObjectProperty property = newModel.getObjectProperty(slot.getURI());
        ExtendedIterator it = property.listDomain();
        CreatePropertyDomainTestCase.assertEquals((Object)newModel.getOntClass(cls.getURI()), it.next());
        CreatePropertyDomainTestCase.assertFalse((boolean)it.hasNext());
    }
}

