/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.protege2jena.tests;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.protege2jena.tests.AbstractProtege2JenaTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import java.util.Iterator;
import java.util.Set;

public class CreateSuperClassesTestCase
extends AbstractProtege2JenaTestCase {
    public void testCreateSimpleNamedOntClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OntModel ontModel = this.createOntModel();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateSuperClassesTestCase.assertNotNull((Object)ontClass);
    }

    public void testCreateOneSuperClass() {
        OWLNamedClass superCls = this.owlModel.createOWLNamedClass("superCls");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(superCls);
        cls.removeSuperclass(this.owlThing);
        OntModel ontModel = this.createOntModel();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateSuperClassesTestCase.assertSize(1, (Iterator)ontClass.listSuperClasses(true));
        CreateSuperClassesTestCase.assertEquals((Object)ontModel.getOntClass(superCls.getURI()), (Object)ontClass.getSuperClass());
    }

    public void testCreateOnlyThingAsSuperClass() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        OntModel ontModel = this.createOntModel();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateSuperClassesTestCase.assertNull((Object)ontClass.getSuperClass());
    }

    public void testCreateTwoSuperClasses() {
        OWLNamedClass superCls1 = this.owlModel.createOWLNamedClass("superCls1");
        OWLNamedClass superCls2 = this.owlModel.createOWLNamedClass("superCls2");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(superCls1);
        cls.addSuperclass(superCls2);
        cls.removeSuperclass(this.owlThing);
        OntModel ontModel = this.createOntModel();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateSuperClassesTestCase.assertSize(2, (Iterator)ontClass.listSuperClasses());
        Set superClasses = Jena.set((Iterator)ontClass.listSuperClasses());
        CreateSuperClassesTestCase.assertContains((Object)ontModel.getOntClass(superCls1.getURI()), superClasses);
        CreateSuperClassesTestCase.assertContains((Object)ontModel.getOntClass(superCls2.getURI()), superClasses);
    }

    public void testCreateTwoSuperClassesIncludingThing() {
        OWLNamedClass superCls1 = this.owlModel.createOWLNamedClass("superCls1");
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        cls.addSuperclass(superCls1);
        OntModel ontModel = this.createOntModel();
        OntClass ontClass = ontModel.getOntClass(cls.getURI());
        CreateSuperClassesTestCase.assertSize(2, (Iterator)ontClass.listSuperClasses());
        Set superClasses = Jena.set((Iterator)ontClass.listSuperClasses());
        CreateSuperClassesTestCase.assertContains((Object)ontModel.getOntClass(superCls1.getURI()), superClasses);
        CreateSuperClassesTestCase.assertContains((Object)OWL.Thing, superClasses);
    }
}

