/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.compact.tests;

import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.classparser.compact.CompactOWLClassParser;
import edu.stanford.smi.protegex.owl.tests.AbstractOWLModelTestCase;

public class ParseCardinalityRestrictionsTestCase
extends AbstractOWLModelTestCase {
    private OWLClassParser parser = new CompactOWLClassParser();

    public void testParseCardiRestriction() throws Exception {
        this.owlModel.createOWLObjectProperty("children");
        String expression = "children = 4";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLCardinality));
        OWLCardinality restriction = (OWLCardinality)aClass;
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("children"));
        ParseCardinalityRestrictionsTestCase.assertTrue((restriction.getCardinality() == 4 ? 1 : 0) != 0);
    }

    public void testParseMaxCardiRestriction() throws Exception {
        this.owlModel.createOWLObjectProperty("children");
        String expression = "children < 4";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLMaxCardinality));
        OWLMaxCardinality restriction = (OWLMaxCardinality)aClass;
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("children"));
        ParseCardinalityRestrictionsTestCase.assertTrue((restriction.getCardinality() == 4 ? 1 : 0) != 0);
    }

    public void testParseMinCardiRestriction() throws Exception {
        this.owlModel.createOWLObjectProperty("children");
        String expression = "children > 4";
        RDFSClass aClass = this.parser.parseClass(this.owlModel, expression);
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)(aClass instanceof OWLMinCardinality));
        OWLMinCardinality restriction = (OWLMinCardinality)aClass;
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("children"));
        ParseCardinalityRestrictionsTestCase.assertTrue((restriction.getCardinality() == 4 ? 1 : 0) != 0);
    }

    public void testParseCardiRestrictionWithNegativeCardinality() throws Exception {
        this.owlModel.createOWLObjectProperty("hasChildren");
        try {
            this.parser.parseClass(this.owlModel, "hasChildren = -1");
            ParseCardinalityRestrictionsTestCase.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testParseQCardinalityRestriction() throws Exception {
        this.owlModel.createOWLObjectProperty("property");
        String expression = "property > 4 owl:Thing";
        RDFSClass cls = this.parser.parseClass(this.owlModel, expression);
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)(cls instanceof OWLMinCardinality));
        OWLMinCardinality restriction = (OWLMinCardinality)cls;
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.isDefined());
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.getOnProperty().getName().equals("property"));
        ParseCardinalityRestrictionsTestCase.assertTrue((restriction.getCardinality() == 4 ? 1 : 0) != 0);
        ParseCardinalityRestrictionsTestCase.assertTrue((boolean)restriction.isQualified());
        ParseCardinalityRestrictionsTestCase.assertEquals((Object)this.owlModel.getOWLThingClass(), (Object)restriction.getValuesFrom());
    }
}

