/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.framestore.AbstractRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

abstract class QuantifierRestrictionUpdater
extends AbstractRestrictionUpdater {
    QuantifierRestrictionUpdater(AbstractOWLModel owlModel) {
        super(owlModel);
    }

    protected void ensureNoSurvivingClsesAreDeleted(Cls cls, Slot slot, Collection clses, Cls metaCls) {
        for (Cls superCls : cls.getDirectSuperclasses()) {
            RDFSClass allCls;
            OWLQuantifierRestriction restriction;
            RDFProperty restrictedSlot;
            if (!superCls.getDirectType().equals(metaCls) || !(restrictedSlot = (restriction = (OWLQuantifierRestriction)superCls).getOnProperty()).equals(slot) || !((allCls = (RDFSClass)restriction.getFiller()) instanceof OWLAnonymousClass)) continue;
            if (clses.contains(allCls)) {
                this.log("& Clearing filler of " + restriction.getBrowserText());
                this.clearFiller(restriction);
                continue;
            }
            if (!(allCls instanceof OWLUnionClass)) continue;
            OWLUnionClass unionCls = (OWLUnionClass)allCls;
            for (RDFSClass operand : new ArrayList(unionCls.getOperands())) {
                if (!(operand instanceof OWLAnonymousClass) || !clses.contains(operand)) continue;
                this.log("& Clearing operand " + operand.getBrowserText() + " from: " + restriction.getBrowserText());
                unionCls.removeOperand(operand);
            }
        }
    }

    protected abstract void clearFiller(OWLQuantifierRestriction var1);

    protected Collection getQuantifierClsClses(RDFSClass quantifierClass) {
        if (quantifierClass != null) {
            if (quantifierClass instanceof OWLUnionClass) {
                return ((OWLUnionClass)quantifierClass).getOperands();
            }
            return Collections.singleton(quantifierClass);
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getSafeClses(Collection base) {
        ArrayList<Cls> copy = new ArrayList<Cls>();
        for (Cls baseCls : base) {
            if (baseCls instanceof RDFSClass) {
                RDFSClass clone = ((RDFSClass)baseCls).createClone();
                copy.add(clone);
                continue;
            }
            copy.add(baseCls);
        }
        return copy;
    }
}

