/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.AbstractRDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractOWLAnonymousClass
extends AbstractRDFSClass
implements OWLAnonymousClass {
    public AbstractOWLAnonymousClass(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public AbstractOWLAnonymousClass() {
    }

    public String getBrowserText() {
        return this.getOWLModel().getOWLClassDisplay().getDisplayText(this);
    }

    public Collection getDependingClasses() {
        return Collections.EMPTY_SET;
    }

    public OWLAnonymousClass getExpressionRoot() {
        RDFProperty rdfFirstProperty = this.getOWLModel().getRDFFirstProperty();
        Collection refs = this.getReferences();
        for (Reference reference : refs) {
            if (reference.getFrame() instanceof OWLAnonymousClass) {
                OWLAnonymousClass reverend = (OWLAnonymousClass)reference.getFrame();
                return reverend.getExpressionRoot();
            }
            if (!(reference.getFrame() instanceof RDFList) || !rdfFirstProperty.equals(reference.getSlot())) continue;
            RDFList list = (RDFList)reference.getFrame();
            RDFList start = list.getStart();
            HashSet set = new HashSet();
            OWLUtil.getReferringLogicalClasses(start, set);
            if (set.size() <= 0) continue;
            OWLAnonymousClass reverend = (OWLAnonymousClass)set.iterator().next();
            return reverend.getExpressionRoot();
        }
        return this;
    }

    public Icon getIcon() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        String iconName = className.substring(index + 8);
        if (this.isEditable()) {
            return OWLIcons.getImageIcon(iconName);
        }
        return OWLIcons.getReadOnlyClsIcon(OWLIcons.getImageIcon(iconName));
    }

    public ImageIcon getImageIcon() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(46);
        String iconName = className.substring(index + 8);
        return OWLIcons.getImageIcon(iconName);
    }

    public OWLNamedClass getOwner() {
        Collection subclasses = this.getSubclasses(false);
        if (subclasses.isEmpty()) {
            OWLAnonymousClass root = this.getExpressionRoot();
            if (this.equals(root)) {
                return null;
            }
            return root.getOwner();
        }
        return (OWLNamedClass)subclasses.iterator().next();
    }

    public boolean isAnonymous() {
        return true;
    }

    public boolean isVisible() {
        return false;
    }
}

