/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class AnnotationPropertyTestCase
extends AbstractJenaTestCase {
    public void testCreateAnnotationDatatypeProperty() {
        OWLDatatypeProperty datatypeSlot = this.owlModel.createAnnotationOWLDatatypeProperty("StringAnno");
        AnnotationPropertyTestCase.assertEquals((Object)ValueType.ANY, (Object)datatypeSlot.getValueType());
        this.assertAnnotationProperty(datatypeSlot);
    }

    public void testCreateAnnotationObjectProperty() {
        OWLObjectProperty objectSlot = this.owlModel.createAnnotationOWLObjectProperty("ObjectAnno");
        AnnotationPropertyTestCase.assertEquals((Object)ValueType.INSTANCE, (Object)objectSlot.getValueType());
        this.assertAnnotationProperty(objectSlot);
    }

    public void testOntologyAnnotationPropertiesHaveDomainDefined() {
        this.assertOntologyProperty("owl:backwardCompatibleWith");
        this.assertOntologyProperty("owl:incompatibleWith");
        this.assertOntologyProperty("owl:priorVersion");
    }

    public void testSetAnnotationPropertyDomain() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty anno = this.owlModel.createAnnotationOWLDatatypeProperty("anno");
        anno.setDomain(cls);
        AnnotationPropertyTestCase.assertEquals((Object)cls, (Object)anno.getDomain(false));
        Collection domainProperties = cls.getUnionDomainProperties(true);
        AnnotationPropertyTestCase.assertContains((Object)anno, domainProperties);
    }

    private void assertAnnotationProperty(OWLProperty property) {
        AnnotationPropertyTestCase.assertTrue((boolean)property.isAnnotationProperty());
        AnnotationPropertyTestCase.assertFalse((boolean)property.isFunctional());
        AnnotationPropertyTestCase.assertFalse((boolean)property.isDomainDefined());
        AnnotationPropertyTestCase.assertEquals((Object)this.owlModel.getRootClses(), (Object)property.getUnionDomain());
    }

    private void assertOntologyProperty(String slotName) {
        OWLProperty property = (OWLProperty)this.owlModel.getSlot(slotName);
        AnnotationPropertyTestCase.assertTrue((boolean)property.isAnnotationProperty());
        AnnotationPropertyTestCase.assertTrue((boolean)property.isDomainDefined());
        AnnotationPropertyTestCase.assertSize(1, property.getUnionDomain());
        AnnotationPropertyTestCase.assertEquals((Object)this.owlModel.getCls("owl:Ontology"), property.getUnionDomain().iterator().next());
    }
}

