/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Collection;

public class DefaultOWLNamedClassTestCase
extends AbstractJenaTestCase {
    public void testGetHasValue() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Subclass", superclass);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLNamedClassTestCase.assertNull((Object)superclass.getHasValue(property));
        DefaultOWLNamedClassTestCase.assertNull((Object)subclass.getHasValue(property));
        superclass.addSuperclass(this.owlModel.createOWLHasValue(property, this.owlThing));
        DefaultOWLNamedClassTestCase.assertEquals((Object)this.owlThing, (Object)superclass.getHasValue(property));
        DefaultOWLNamedClassTestCase.assertEquals((Object)this.owlThing, (Object)subclass.getHasValue(property));
    }

    public void testGetRestrictionsAllValuesFrom() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Subclass", superclass);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass otherClass = this.owlModel.createOWLNamedClass("Other");
        property.setRange(otherClass);
        DefaultOWLNamedClassTestCase.assertEquals((Object)otherClass, (Object)subclass.getAllValuesFrom(property));
        OWLAllValuesFrom superRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, subclass);
        superclass.addSuperclass(superRestriction);
        OWLAllValuesFrom subRestriction = this.owlModel.createOWLAllValuesFrom((RDFProperty)property, subclass);
        subclass.addSuperclass(subRestriction);
        DefaultOWLNamedClassTestCase.assertSize(1, superclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)superRestriction, superclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertSize(1, subclass.getRestrictions(false));
        DefaultOWLNamedClassTestCase.assertSize(1, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)subRestriction, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertEquals((Object)subclass, (Object)subclass.getAllValuesFrom(property));
    }

    public void testGetRestrictionsMinCardinality() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Subclass", superclass);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLNamedClassTestCase.assertEquals((int)0, (int)subclass.getMinCardinality(property));
        OWLMinCardinality superMinCardinality = this.owlModel.createOWLMinCardinality(property, 1);
        superclass.addSuperclass(superMinCardinality);
        OWLMaxCardinality subMaxCardinality = this.owlModel.createOWLMaxCardinality(property, 2);
        subclass.addSuperclass(subMaxCardinality);
        DefaultOWLNamedClassTestCase.assertSize(1, superclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)superMinCardinality, superclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertSize(2, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)superMinCardinality, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)subMaxCardinality, subclass.getRestrictions(true));
        OWLMinCardinality subMinCardinality = this.owlModel.createOWLMinCardinality(property, 2);
        subclass.addSuperclass(subMinCardinality);
        DefaultOWLNamedClassTestCase.assertSize(2, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)subMinCardinality, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)subMaxCardinality, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertEquals((int)2, (int)subclass.getMinCardinality(property));
    }

    public void testGetRestrictionsMaxCardinality() {
        OWLNamedClass superclass = this.owlModel.createOWLNamedClass("Superclass");
        OWLNamedClass subclass = this.owlModel.createOWLNamedSubclass("Subclass", superclass);
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultOWLNamedClassTestCase.assertEquals((int)-1, (int)subclass.getMaxCardinality(property));
        OWLMaxCardinality superRestriction = this.owlModel.createOWLMaxCardinality(property, 3);
        superclass.addSuperclass(superRestriction);
        DefaultOWLNamedClassTestCase.assertSize(0, subclass.getRestrictions(false));
        DefaultOWLNamedClassTestCase.assertSize(1, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)superRestriction, subclass.getRestrictions(true));
        OWLMaxCardinality subRestriction = this.owlModel.createOWLMaxCardinality(property, 2);
        subclass.addSuperclass(subRestriction);
        DefaultOWLNamedClassTestCase.assertSize(1, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertContains((Object)subRestriction, subclass.getRestrictions(true));
        DefaultOWLNamedClassTestCase.assertEquals((int)2, (int)subclass.getMaxCardinality(property));
        property.setFunctional(true);
        DefaultOWLNamedClassTestCase.assertEquals((int)1, (int)subclass.getMaxCardinality(property));
    }

    public void testGetSubclassesOfOWLThing() {
        Collection subs = this.owlThing.getSubclasses(false);
        for (Object subclass : subs) {
            DefaultOWLNamedClassTestCase.assertTrue((boolean)(subclass instanceof RDFSNamedClass));
        }
        DefaultOWLNamedClassTestCase.assertEquals((int)subs.size(), (int)this.owlThing.getSubclassCount());
    }
}

