/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.List;

public class NamespacePrefixTestCase
extends AbstractJenaTestCase {
    public void testDefaultOntologyName() throws Exception {
        OWLOntology ontology = this.owlModel.getDefaultOWLOntology();
        NamespacePrefixTestCase.assertEquals((String)":", (String)ontology.getName());
        NamespacePrefixTestCase.assertEquals((String)"http://www.owl-ontologies.com/unnamed.owl", (String)ontology.getURI());
    }

    public void testOtherOntologyName() {
        String namespaceBase = "http://aldi.de";
        String namespace = String.valueOf(namespaceBase) + "#";
        String prefix = "aldi";
        this.owlModel.getNamespaceManager().setPrefix(namespace, prefix);
        OWLOntology ontology = this.owlModel.createOWLOntology(String.valueOf(prefix) + ":", namespace);
        NamespacePrefixTestCase.assertEquals((String)namespaceBase, (String)ontology.getURI());
    }

    public void testDefaultPrefix() {
        Slot prefixesSlot = this.owlModel.getSlot(":OWL-ONTOLOGY-PREFIXES");
        NamespaceManager nsm = this.owlModel.getNamespaceManager();
        NamespacePrefixTestCase.assertEquals((String)"http://www.owl-ontologies.com/unnamed.owl#", (String)nsm.getDefaultNamespace());
        String CLS_NAME = "Person";
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        NamespacePrefixTestCase.assertEquals((String)nsm.getDefaultNamespace(), (String)cls.getNamespace());
        NamespacePrefixTestCase.assertEquals((String)(String.valueOf(nsm.getDefaultNamespace()) + "Person"), (String)cls.getURI());
        NamespacePrefixTestCase.assertEquals((String)"Person", (String)cls.getLocalName());
        NamespacePrefixTestCase.assertEquals((String)"Person", (String)cls.getBrowserText());
        List values = this.owlModel.getDefaultOWLOntology().getDirectOwnSlotValues(prefixesSlot);
        NamespacePrefixTestCase.assertEquals((int)5, (int)values.size());
    }

    public void testChangePrefix() {
        Slot prefixesSlot = this.owlModel.getSlot(":OWL-ONTOLOGY-PREFIXES");
        NamespaceManager nsm = this.owlModel.getNamespaceManager();
        NamespacePrefixTestCase.assertEquals((String)"http://www.owl-ontologies.com/unnamed.owl#", (String)nsm.getDefaultNamespace());
        String NAMESPACE = "http://aldi.de#";
        String ALDI = "aldi";
        nsm.setPrefix(NAMESPACE, ALDI);
        List values = this.owlModel.getDefaultOWLOntology().getDirectOwnSlotValues(prefixesSlot);
        NamespacePrefixTestCase.assertEquals((int)6, (int)values.size());
        NamespacePrefixTestCase.assertTrue((boolean)values.contains(String.valueOf(ALDI) + ":" + NAMESPACE));
        String LIDL = "lidl";
        nsm.setPrefix(NAMESPACE, LIDL);
        values = this.owlModel.getDefaultOWLOntology().getDirectOwnSlotValues(prefixesSlot);
        NamespacePrefixTestCase.assertEquals((int)6, (int)values.size());
        NamespacePrefixTestCase.assertFalse((boolean)values.contains(String.valueOf(ALDI) + ":" + NAMESPACE));
        NamespacePrefixTestCase.assertTrue((boolean)values.contains(String.valueOf(LIDL) + ":" + NAMESPACE));
    }

    public void testOntologyInstanceValues() {
        Slot prefixesSlot = this.owlModel.getSlot(":OWL-ONTOLOGY-PREFIXES");
        NamespaceManager nsm = this.owlModel.getNamespaceManager();
        NamespacePrefixTestCase.assertEquals((String)"http://www.owl-ontologies.com/unnamed.owl#", (String)nsm.getDefaultNamespace());
        String CLS_NAME = "Person";
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Person");
        String NAMESPACE = "http://aldi.de#";
        String ALDI = "aldi";
        nsm.setPrefix(NAMESPACE, ALDI);
        List values = this.owlModel.getDefaultOWLOntology().getDirectOwnSlotValues(prefixesSlot);
        NamespacePrefixTestCase.assertEquals((int)6, (int)values.size());
        NamespacePrefixTestCase.assertTrue((boolean)values.contains(String.valueOf(ALDI) + ":" + NAMESPACE));
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass(String.valueOf(ALDI) + ":" + "Person");
        NamespacePrefixTestCase.assertEquals((String)"Person", (String)otherCls.getLocalName());
        NamespacePrefixTestCase.assertEquals((String)NAMESPACE, (String)otherCls.getNamespace());
        String LIDL = "lidl";
        nsm.setPrefix(NAMESPACE, LIDL);
        values = this.owlModel.getDefaultOWLOntology().getDirectOwnSlotValues(prefixesSlot);
        NamespacePrefixTestCase.assertEquals((int)6, (int)values.size());
        NamespacePrefixTestCase.assertTrue((boolean)values.contains(String.valueOf(LIDL) + ":" + NAMESPACE));
    }
}

