/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class RDFPropertyPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;
    private Set specialPropertyTypes = new HashSet();
    private RDFSNamedClass symmetricPropertyClass;
    private RDFSNamedClass transitivePropertyClass;

    RDFPropertyPostProcessor(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.kb = owlModel;
        this.symmetricPropertyClass = owlModel.getRDFSNamedClass("owl:SymmetricProperty");
        this.transitivePropertyClass = owlModel.getRDFSNamedClass("owl:TransitiveProperty");
        this.specialPropertyTypes.add(owlModel.getOWLAnnotationPropertyClass());
        this.specialPropertyTypes.add(owlModel.getOWLFunctionalPropertyClass());
        this.specialPropertyTypes.add(owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty"));
        this.specialPropertyTypes.add(this.symmetricPropertyClass);
        this.specialPropertyTypes.add(this.transitivePropertyClass);
        this.specialPropertyTypes.add(owlModel.getRDFSNamedClass("owl:DeprecatedProperty"));
        for (RDFProperty property : owlModel.getUserDefinedRDFProperties()) {
            TripleStoreUtil.ensureActiveTripleStore(property);
            property = this.updatePrimaryDirectType(property);
            this.updateValueType(property);
            this.updateDirectDomain(property);
        }
    }

    private void updateDirectDomain(Slot slot) {
        boolean oldValue = this.owlModel.getOWLFrameStore().suppressUpdateRDFSDomain;
        this.owlModel.getOWLFrameStore().suppressUpdateRDFSDomain = true;
        ArrayList<Cls> newDirectDomain = new ArrayList<Cls>();
        List domains = slot.getDirectOwnSlotValues((Slot)this.owlModel.getRDFSDomainProperty());
        if (domains.size() == 1) {
            RDFSClass domainClass = (RDFSClass)domains.iterator().next();
            if (domainClass instanceof OWLUnionClass) {
                newDirectDomain.addAll(((OWLUnionClass)domainClass).getOperands());
            } else {
                newDirectDomain.add(domainClass);
            }
        }
        if (domains.size() > 1) {
            Cls firstClass = (Cls)domains.iterator().next();
            newDirectDomain.add(firstClass);
        }
        ArrayList directDomain = new ArrayList(slot.getDirectDomain());
        for (Cls domainCls : directDomain) {
            if (newDirectDomain.contains(domainCls)) continue;
            domainCls.removeDirectTemplateSlot(slot);
        }
        for (Cls cls : newDirectDomain) {
            if (cls.hasDirectTemplateSlot(slot)) continue;
            cls.addDirectTemplateSlot(slot);
        }
        if (slot.getDirectSuperslotCount() == 0 && slot.getDirectDomain().isEmpty()) {
            this.kb.getRootCls().addDirectTemplateSlot(slot);
        }
        this.owlModel.getOWLFrameStore().suppressUpdateRDFSDomain = oldValue;
    }

    private RDFProperty updatePrimaryDirectType(Slot property) {
        Collection types = property.getDirectTypes();
        boolean hasNoOtherType = true;
        RDFSNamedClass newType = this.owlModel.getRDFPropertyClass();
        for (Cls type : types) {
            if (!this.specialPropertyTypes.contains(type)) {
                hasNoOtherType = false;
                break;
            }
            if (!this.symmetricPropertyClass.equals(type) && !this.transitivePropertyClass.equals(type)) continue;
            newType = this.owlModel.getOWLObjectPropertyClass();
        }
        if (hasNoOtherType) {
            if (types.contains(this.owlModel.getOWLAnnotationPropertyClass())) {
                newType = this.owlModel.getOWLDatatypePropertyClass();
            }
            property.addDirectType((Cls)newType);
        }
        if (property.getDirectTypes().size() > 1) {
            for (Cls type : this.specialPropertyTypes) {
                if (!types.contains(type)) continue;
                property.removeDirectType(type);
                property.addDirectType(type);
                property = this.owlModel.getRDFProperty(property.getName());
            }
        }
        return (RDFProperty)property;
    }

    private void updateValueType(RDFProperty property) {
        RDFProperty slot = property;
        Collection ranges = property.getRanges(false);
        if (ranges.isEmpty()) {
            if (property.getSuperpropertyCount() == 0) {
                if (property instanceof OWLObjectProperty) {
                    slot.setValueType(ValueType.INSTANCE);
                } else {
                    slot.setValueType(ValueType.ANY);
                }
            } else {
                Slot valueTypeSlot = this.kb.getSlot(":SLOT-VALUE-TYPE");
                if (!slot.getDirectOwnSlotValues(valueTypeSlot).isEmpty()) {
                    slot.setOwnSlotValues(valueTypeSlot, Collections.EMPTY_LIST);
                }
            }
        } else {
            Object range = ranges.iterator().next();
            if (range instanceof RDFSDatatype) {
                String uri = ((RDFSDatatype)range).getURI();
                ValueType valueType = XMLSchemaDatatypes.getValueType(uri);
                slot.setValueType(valueType);
            } else if (range instanceof OWLDataRange) {
                OWLDataRange dataRange = (OWLDataRange)range;
                List literals = dataRange.getOneOfValueLiterals();
                if (literals.isEmpty()) {
                    slot.setValueType(ValueType.ANY);
                } else {
                    RDFSLiteral literal = (RDFSLiteral)literals.iterator().next();
                    String uri = literal.getDatatype().getURI();
                    ValueType valueType = XMLSchemaDatatypes.getValueType(uri);
                    slot.setValueType(valueType);
                }
            } else {
                Collection oldAllowedClses;
                if (slot.getValueType() != ValueType.INSTANCE) {
                    slot.setValueType(ValueType.INSTANCE);
                    oldAllowedClses = Collections.EMPTY_LIST;
                } else {
                    oldAllowedClses = slot.getAllowedClses();
                }
                Collection newAllowedClses = null;
                newAllowedClses = range instanceof OWLUnionClass ? ((OWLUnionClass)range).getOperands() : (Collection)Collections.singleton(range);
                if (!CollectionUtilities.containSameItems((Collection)oldAllowedClses, (Collection)newAllowedClses)) {
                    slot.setAllowedClses(newAllowedClses);
                }
            }
        }
    }
}

