/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ChangeRDFTypeTestCase
extends AbstractJenaTestCase {
    public void testAddRDFType() {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        ChangeRDFTypeTestCase.assertFalse((boolean)property.isFunctional());
        RDFSNamedClass type = this.owlModel.getOWLFunctionalPropertyClass();
        this.owlModel.getTripleStoreModel().getActiveTripleStore().add(property, this.owlModel.getRDFTypeProperty(), type);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        ChangeRDFTypeTestCase.assertTrue((boolean)property.isFunctional());
        ChangeRDFTypeTestCase.assertContains((Object)property, this.owlModel.getOWLDatatypePropertyClass().getInstances(false));
        ChangeRDFTypeTestCase.assertContains((Object)property, this.owlModel.getOWLFunctionalPropertyClass().getInstances(false));
    }

    public void testRemoveRDFType() {
        OWLDatatypeProperty property = this.owlModel.createOWLDatatypeProperty("property");
        property.setFunctional(true);
        ChangeRDFTypeTestCase.assertTrue((boolean)property.isFunctional());
        RDFSNamedClass type = this.owlModel.getOWLFunctionalPropertyClass();
        this.owlModel.getTripleStoreModel().getActiveTripleStore().remove(property, this.owlModel.getRDFTypeProperty(), type);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        ChangeRDFTypeTestCase.assertFalse((boolean)property.isFunctional());
        ChangeRDFTypeTestCase.assertContains((Object)property, this.owlModel.getOWLDatatypePropertyClass().getInstances(false));
        ChangeRDFTypeTestCase.assertFalse((boolean)this.owlModel.getOWLFunctionalPropertyClass().getInstances(false).contains(property));
    }
}

