/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ResourceCopier
extends OWLModelVisitorAdapter {
    private RDFObject copy;
    protected static String[] doNotCopySlots = new String[]{":DIRECT-SUBCLASSES", ":DIRECT-SUPERCLASSES", "rdfs:subClassOf", "owl:equivalentClass", ":NAME"};
    private Collection doNotCopySlotsList;
    private OWLModel owlModel;

    public RDFObject getCopy() {
        return this.copy;
    }

    public void visitOWLNamedClass(OWLNamedClass source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitOWLIndividual(OWLIndividual source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitOWLObjectProperty(OWLObjectProperty source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitRDFSNamedClass(RDFSNamedClass source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitRDFIndividual(RDFIndividual source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitRDFProperty(RDFProperty source) {
        this.visitResourceToBeReferenced(source);
    }

    public void visitRDFDatatype(RDFSDatatype source) {
        this.visitResourceToBeReferenced(source);
    }

    protected void visitResourceToBeReferenced(RDFResource source) {
        if (!source.isSystem()) {
            if (source.getOWLModel() != this.owlModel) {
                this.owlModel = source.getOWLModel();
            }
            if (this.owlModel.getDefaultOWLOntology().getImports().size() > 0) {
                TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
                TripleStore ts = tsm.getHomeTripleStore(source);
                TripleStore activeTs = tsm.getActiveTripleStore();
                if (activeTs != ts) {
                    String ns = ts.getDefaultNamespace();
                    String homeOntologyName = ns.substring(0, ns.length() - 1);
                    OWLOntology activeOnt = OWLUtil.getActiveOntology(this.owlModel);
                    if (!activeOnt.getImports().contains(homeOntologyName)) {
                        activeOnt.addImports(homeOntologyName);
                    }
                }
            }
        }
        this.copy = source;
    }

    public void visitRDFSLiteral(RDFSLiteral source) {
        this.copy = source;
    }

    public void visitRDFUntypedResource(RDFUntypedResource source) {
        this.copy = source;
    }

    public void visitOWLUnionClass(OWLUnionClass source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLUnionClass());
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLIntersectionClass());
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLEnumeratedClass());
    }

    public void visitOWLComplementClass(OWLComplementClass source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLComplementClass());
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLSomeValuesFrom());
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLAllValuesFrom());
    }

    public void visitOWLCardinality(OWLCardinality source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLCardinality());
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLMaxCardinality());
    }

    public void visitOWLMinCardinality(OWLMinCardinality source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLMinCardinality());
    }

    public void visitOWLHasValue(OWLHasValue source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLHasValue());
    }

    public void visitRDFList(RDFList source) {
        if (source == source.getOWLModel().getRDFNil()) {
            this.copy = source;
        } else {
            this.copyMultipleSlotValues(source, source.getOWLModel().createRDFList());
        }
    }

    public void visitOWLAllDifferent(OWLAllDifferent source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLAllDifferent());
    }

    public void visitOWLDataRange(OWLDataRange source) {
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLDataRange());
    }

    public void visitOWLOntology(OWLOntology source) {
        String newName = null;
        int i = 2;
        do {
            newName = String.valueOf(source.getName()) + i;
            ++i;
        } while (source.getOWLModel().getRDFResource(newName) != null);
        this.copyMultipleSlotValues(source, source.getOWLModel().createOWLOntology(newName));
    }

    public void copyMultipleSlotValues(RDFResource source, RDFResource target) {
        if (source.getOWLModel() != this.owlModel) {
            this.owlModel = source.getOWLModel();
            this.doNotCopySlotsList = new HashSet();
            int i = 0;
            while (i < doNotCopySlots.length) {
                this.doNotCopySlotsList.add(this.owlModel.getSlot(doNotCopySlots[i]));
                ++i;
            }
        }
        for (Slot slot : source.getOwnSlots()) {
            if (this.doNotCopySlotsList.contains(slot)) continue;
            this.copySlotValues(source, target, slot);
        }
        this.copy = target;
    }

    public void copySlotValues(RDFResource source, RDFResource target, Slot slot) {
        List values = source.getDirectOwnSlotValues(slot);
        if (values != null && values.size() > 0) {
            ArrayList newvalues = new ArrayList(values.size());
            for (Object value : values) {
                if (value instanceof RDFObject) {
                    ((RDFObject)value).accept(this);
                    value = this.copy;
                }
                if (value == null) continue;
                newvalues.add(value);
            }
            if (newvalues.size() > 0) {
                target.setDirectOwnSlotValues(slot, newvalues);
            }
        }
    }
}

