/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util.tests;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.util.XSDVisibility;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.Set;

public class XSDVisibilityTestCase
extends AbstractJenaTestCase {
    public void testNewProject() {
        XSDVisibility.updateVisibility(this.owlModel);
        Set defaultDatatypes = XSDVisibility.getDefaultDatatypes(this.owlModel);
        for (RDFSDatatype datatype : this.owlModel.getRDFSDatatypes()) {
            if (defaultDatatypes.contains(datatype)) {
                XSDVisibilityTestCase.assertTrue((boolean)datatype.isVisible());
                continue;
            }
            XSDVisibilityTestCase.assertFalse((boolean)datatype.isVisible());
        }
    }

    public void testUseXSDinteger() {
        RDFSDatatype type = this.owlModel.getXSDinteger();
        XSDVisibilityTestCase.assertFalse((boolean)XSDVisibility.getDefaultDatatypes(this.owlModel).contains(type));
        XSDVisibility.updateVisibility(this.owlModel);
        XSDVisibilityTestCase.assertFalse((boolean)type.isVisible());
        RDFProperty property = this.owlModel.createRDFProperty("property");
        property.setRange(type);
        XSDVisibility.updateVisibility(this.owlModel);
        XSDVisibilityTestCase.assertTrue((boolean)type.isVisible());
    }
}

