/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.util.Log;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLBaseExtractor {
    private InputStream is;
    private URI xmlBase;
    private String rootElementName;
    private String defaultNamespace;

    public XMLBaseExtractor(InputStream is) {
        this.is = is;
        this.xmlBase = null;
    }

    public URI getXMLBase() {
        SAXParser parser = new SAXParser();
        parser.setContentHandler((ContentHandler)new MyHandler());
        try {
            parser.parse(new InputSource(this.is));
        }
        catch (Throwable throwable) {}
        return this.xmlBase;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    private class MyHandler
    implements ContentHandler {
        private boolean startElement;

        private MyHandler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (!this.startElement) {
                XMLBaseExtractor.this.rootElementName = qName;
                int i = 0;
                while (i < atts.getLength()) {
                    if (atts.getQName(i).equals("xml:base")) {
                        URI attURL = null;
                        try {
                            attURL = new URI(atts.getValue(i));
                        }
                        catch (URISyntaxException e) {
                            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
                        }
                        XMLBaseExtractor.this.xmlBase = attURL;
                    } else if (atts.getLocalName(i).equals("xmlns")) {
                        XMLBaseExtractor.this.defaultNamespace = atts.getValue(i);
                    }
                    ++i;
                }
            } else {
                throw new SAXException("No xml:base");
            }
            this.startElement = true;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }
}

