/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidIndividualNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.ArrayList;
import java.util.List;

public class PropertyInfo
extends Info {
    private Argument subject;
    private Argument predicate;
    private List domainClassNames;
    private List rangeClassNames;

    public PropertyInfo(String propertyName, Argument subject, Argument predicate, List domainClassNames, List rangeClassNames) throws SWRLRuleEngineBridgeException {
        super(propertyName);
        this.subject = subject;
        this.predicate = predicate;
        this.domainClassNames = domainClassNames;
        this.rangeClassNames = rangeClassNames;
    }

    public PropertyInfo(String propertyName, Argument subject, Argument predicate) throws SWRLRuleEngineBridgeException {
        super(propertyName);
        this.subject = subject;
        this.predicate = predicate;
    }

    public Argument getSubject() {
        return this.subject;
    }

    public Argument getPredicate() {
        return this.predicate;
    }

    public List getDomainClassNames() {
        return this.domainClassNames;
    }

    public List getRangeClassNames() {
        return this.rangeClassNames;
    }

    public void write2OWL(OWLModel owlModel) throws SWRLRuleEngineBridgeException {
        Object object;
        OWLProperty property = this.getName().equalsIgnoreCase("sameAs") ? (OWLProperty)owlModel.getOWLSameAsProperty() : (this.getName().equalsIgnoreCase("differentFrom") ? (OWLProperty)owlModel.getOWLDifferentFromProperty() : owlModel.getOWLProperty(this.getName()));
        if (property == null) {
            throw new InvalidPropertyNameException(this.getName());
        }
        OWLIndividual individual = owlModel.getOWLIndividual(this.subject.getName());
        if (individual == null) {
            throw new InvalidIndividualNameException(this.subject.getName());
        }
        if (property.isObjectProperty()) {
            object = owlModel.getOWLIndividual(this.predicate.getName());
            if (object == null) {
                throw new InvalidIndividualNameException(this.predicate.getName());
            }
        } else {
            LiteralInfo literalInfo = (LiteralInfo)this.predicate;
            object = literalInfo.isString() ? literalInfo.getString() : owlModel.asRDFSLiteral(literalInfo.getString());
        }
        if (!individual.hasPropertyValue(property, object, true)) {
            individual.addPropertyValue(property, object);
        }
    }

    public String toString() {
        return "Property(name: " + this.getName() + ", subject: " + this.subject + ", predicate: " + this.predicate + ", domainClassNames: " + this.domainClassNames + ", rangeClassNames: " + this.rangeClassNames + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PropertyInfo info = (PropertyInfo)obj;
        return (this.getName() == info.getName() || this.getName() != null && this.getName().equals(info.getName())) && (this.subject == info.subject || this.subject != null && this.subject.equals(info.subject)) && (this.predicate == info.predicate || this.predicate != null && this.predicate.equals(info.predicate)) && (this.domainClassNames == info.domainClassNames || this.domainClassNames != null && this.domainClassNames.equals(info.domainClassNames)) && (this.rangeClassNames == info.rangeClassNames || this.rangeClassNames != null && this.rangeClassNames.equals(info.rangeClassNames));
    }

    public int hashCode() {
        int hash = 767;
        hash += this.getName() == null ? 0 : this.getName().hashCode();
        hash += this.subject == null ? 0 : this.subject.hashCode();
        hash += this.predicate == null ? 0 : this.predicate.hashCode();
        hash += this.domainClassNames == null ? 0 : this.domainClassNames.hashCode();
        return hash += this.rangeClassNames == null ? 0 : this.rangeClassNames.hashCode();
    }

    public static List buildPropertyInfoList(OWLModel owlModel, String propertyName) throws SWRLRuleEngineBridgeException {
        ArrayList<PropertyInfo> propertyInfoList = new ArrayList<PropertyInfo>();
        RDFProperty property = owlModel.getRDFProperty(propertyName);
        if (property == null) {
            throw new InvalidPropertyNameException(propertyName);
        }
        List domainClassNames = PropertyInfo.rdfResources2NamesList(property.getUnionDomain());
        List rangeClassNames = PropertyInfo.rdfResources2NamesList(property.getUnionRangeClasses());
        for (RDFSClass rdfsClass : property.getUnionDomain()) {
            for (Object object : rdfsClass.getInstances(true)) {
                PropertyInfo propertyInfo;
                Info predicate;
                IndividualInfo subject;
                OWLIndividual domainIndividual;
                if (!(object instanceof OWLIndividual) || !(domainIndividual = (OWLIndividual)object).hasPropertyValue(property)) continue;
                if (property.hasObjectRange()) {
                    for (OWLIndividual rangeIndividual : domainIndividual.getPropertyValues(property)) {
                        subject = new IndividualInfo(domainIndividual.getName());
                        predicate = new IndividualInfo(rangeIndividual.getName());
                        propertyInfo = new PropertyInfo(propertyName, subject, (Argument)((Object)predicate), domainClassNames, rangeClassNames);
                        propertyInfoList.add(propertyInfo);
                    }
                    continue;
                }
                for (RDFSLiteral literal : domainIndividual.getPropertyValueLiterals(property)) {
                    subject = new IndividualInfo(domainIndividual.getName());
                    predicate = new LiteralInfo(owlModel, literal);
                    propertyInfo = new PropertyInfo(propertyName, subject, (Argument)((Object)predicate), domainClassNames, rangeClassNames);
                    propertyInfoList.add(propertyInfo);
                }
            }
        }
        return propertyInfoList;
    }
}

