/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.examples;

import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Vector;

public class SWRLFactoryTest {
    public static void main(String[] args) throws Exception {
        Vector error_messages = new Vector();
        JenaKnowledgeBaseFactory factory = new JenaKnowledgeBaseFactory();
        Project project = new Project(null, error_messages);
        project.setKnowledgeBaseFactory((KnowledgeBaseFactory)factory);
        project.createDomainKnowledgeBase((KnowledgeBaseFactory)factory, error_messages, false);
        JenaOWLModel owlModel = (JenaOWLModel)project.getKnowledgeBase();
        owlModel.load(new URI("http://protege.stanford.edu/plugins/owl/testdata/importSWRL.owl"), "RDF/XML-ABBREV", error_messages);
        if (!error_messages.isEmpty()) {
            System.err.println("Error loading importSWRL.owl:" + error_messages);
            System.exit(-1);
        }
        SWRLFactory swrlFactory = new SWRLFactory(owlModel);
        owlModel.setFrameFactory((FrameFactory)new SWRLJavaFactory((OWLModel)owlModel));
        SWRLFactoryTest.testRuleCreation(swrlFactory, owlModel);
    }

    private static void testRuleCreation(SWRLFactory swrlFactory, JenaOWLModel owlModel) {
        OWLNamedClass pizzaClass = owlModel.createOWLNamedClass("Pizza");
        OWLNamedClass pizzaBase = owlModel.createOWLNamedClass("PizzaBase");
        OWLObjectProperty hasIngredient = owlModel.createOWLObjectProperty("hasIngredient");
        OWLDatatypeProperty myDatatypeProperty = owlModel.createOWLDatatypeProperty("myDatatypeProperty");
        SWRLVariable x = swrlFactory.createVariable("x");
        SWRLVariable y = swrlFactory.createVariable("y");
        SWRLVariable z = swrlFactory.createVariable("z");
        SWRLBuiltin lessThanBuiltin = swrlFactory.createBuiltin("lessThan");
        SWRLAtomList head = swrlFactory.createAtomList();
        SWRLAtomList body = swrlFactory.createAtomList();
        SWRLClassAtom classAtom = swrlFactory.createClassAtom(pizzaClass, x);
        body.append(classAtom);
        classAtom = swrlFactory.createClassAtom(pizzaBase, z);
        head.append(classAtom);
        SWRLSameIndividualAtom sameIndividualAtom = swrlFactory.createSameIndividualAtom(x, y);
        head.append(sameIndividualAtom);
        ArrayList<SWRLVariable> arguments = new ArrayList<SWRLVariable>();
        arguments.add(x);
        arguments.add(y);
        SWRLBuiltinAtom builtinAtom = swrlFactory.createBuiltinAtom(lessThanBuiltin, arguments.iterator());
        head.append(builtinAtom);
        SWRLIndividualPropertyAtom individualPropertyAtom = swrlFactory.createIndividualPropertyAtom(hasIngredient, x, z);
        head.append(individualPropertyAtom);
        RDFSLiteral literalValue = owlModel.createRDFSLiteral("ddd", owlModel.getXSDstring());
        SWRLDatavaluedPropertyAtom datavaluedPropertyAtom = swrlFactory.createDatavaluedPropertyAtom(myDatatypeProperty, x, literalValue);
        head.append(datavaluedPropertyAtom);
        OWLDataRange dataRange = owlModel.createOWLDataRange(new RDFSLiteral[]{owlModel.createRDFSLiteral("first"), owlModel.createRDFSLiteral("second")});
        SWRLDataRangeAtom dataRangeAtom = swrlFactory.createDataRangeAtom(dataRange, x);
        head.append(dataRangeAtom);
        RDFSDatatype datatype = owlModel.getXSDdouble();
        head.append(swrlFactory.createDataRangeAtom(datatype, x));
        SWRLImp imp = swrlFactory.createImp(head, body);
        System.out.println("Imp: " + imp.getBrowserText());
    }
}

