/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLIncompleteRuleException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SWRLTextField
extends SymbolTextField {
    private static final char[][] charMap = new char[][]{{'^', '\u2227'}};

    public SWRLTextField(OWLModel owlModel, SymbolErrorDisplay errorDisplay) {
        super(owlModel, errorDisplay, new SWRLResourceNameMatcher(), new SWRLSyntaxConverter(owlModel));
        SWRLTextField.initKeymap(this);
    }

    protected void checkUniCodeExpression(String uniCodeText) throws Throwable {
        SWRLParser parser = new SWRLParser(this.getOWLModel());
        if (this.isInSaveTestMode()) {
            parser.parse(uniCodeText);
        } else {
            try {
                parser.parse(uniCodeText);
            }
            catch (SWRLIncompleteRuleException sWRLIncompleteRuleException) {
                // empty catch block
            }
        }
    }

    public static void initKeymap(JTextComponent textComponent) {
        textComponent.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                char ch = evt.getKeyChar();
                int i = 0;
                while (i < charMap.length) {
                    char[] chars = charMap[i];
                    if (chars[0] == ch) {
                        JTextComponent c = (JTextComponent)evt.getSource();
                        try {
                            c.getDocument().insertString(c.getCaretPosition(), "" + chars[1], null);
                            evt.consume();
                            return;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        });
    }
}

