/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.classform.component.FormComponent;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.AddIndividualAction;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.AddNamedClassAction;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.ChangeClosureAxiomButton;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.DeleteRowAction;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTable;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class PropertyFormComponent
extends FormComponent {
    private AddIndividualAction addIndividualAction;
    private AddNamedClassAction addNamedClassAction;
    private ChangeClosureAxiomButton closureAxiomAction;
    private DeleteRowAction deleteRowAction;
    private OWLLabeledComponent lc;
    private RDFProperty property;
    private PropertyFormTable table;
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void browserTextChanged(RDFResource resource) {
            PropertyFormComponent.this.updatePropertyBrowserText();
        }
    };
    private static final int MAX_ROWS = 8;

    public PropertyFormComponent(RDFProperty property) {
        this.property = property;
        property.addPropertyValueListener(this.valueListener);
    }

    public void dispose() {
        this.property.removePropertyValueListener(this.valueListener);
    }

    public Dimension getPreferredSize() {
        if (this.lc != null && this.table != null) {
            Dimension superSize = super.getPreferredSize();
            Dimension lcSize = this.lc.getCenterComponent().getPreferredSize();
            int width = superSize.width - lcSize.width;
            int rowCount = Math.min(Math.max(1, this.table.getTableModel().getRowCount()), 8);
            int rowHeight = this.table.getRowHeight();
            int height = superSize.height - lcSize.height + rowCount * rowHeight + 3;
            return new Dimension(width, height);
        }
        return new Dimension(0, 0);
    }

    public void init(OWLModel owlModel) {
    }

    public void setNamedClass(OWLNamedClass cls) {
        if (this.table != null) {
            ComponentUtilities.dispose((Component)((Object)this.table));
        }
        PropertyFormTableModel tableModel = new PropertyFormTableModel(cls, this.property);
        this.table = new PropertyFormTable(tableModel, cls, this.property);
        JScrollPane sp = new JScrollPane((Component)((Object)this.table));
        sp.getViewport().setBackground(Color.white);
        String text = String.valueOf(this.property.getBrowserText()) + "  ";
        text = this.table.isClosed() ? String.valueOf(text) + "only some" : String.valueOf(text) + "some";
        this.lc = new OWLLabeledComponent(text, sp);
        this.addNamedClassAction = new AddNamedClassAction(this.table);
        this.addIndividualAction = new AddIndividualAction(this.table);
        this.deleteRowAction = new DeleteRowAction(this.table);
        this.closureAxiomAction = new ChangeClosureAxiomButton(this.table);
        this.lc.addHeaderButton(this.addNamedClassAction);
        this.lc.addHeaderButton(this.addIndividualAction);
        this.lc.addHeaderButton(this.deleteRowAction);
        this.setContent((JComponent)((Object)this.lc));
    }

    private void updatePropertyBrowserText() {
        this.lc.setHeaderLabel(this.property.getBrowserText());
    }
}

