/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.form;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ClosureAxiomFactory;
import edu.stanford.smi.protegex.owl.ui.cls.SwitchableType;
import edu.stanford.smi.protegex.owl.ui.widget.ClassFormWidget;
import java.util.ArrayList;
import java.util.List;

public class ClassFormSwitchableType
implements SwitchableType {
    public String getButtonText() {
        return "Form View";
    }

    private List getParentClasses(RDFSNamedClass namedClass) {
        ArrayList<RDFSClass> classes = new ArrayList<RDFSClass>();
        for (RDFSClass rdfsClass : namedClass.getSuperclasses(true)) {
            if (rdfsClass instanceof OWLIntersectionClass) {
                classes.addAll(((OWLIntersectionClass)rdfsClass).getOperands());
                continue;
            }
            classes.add(rdfsClass);
        }
        return classes;
    }

    public Class getWidgetClassType() {
        return ClassFormWidget.class;
    }

    private boolean isClosureAxiom(OWLNamedClass namedClass, List classes, OWLAllValuesFrom allValuesFrom) {
        boolean existentialExists = false;
        boolean closed = false;
        for (RDFSClass e : classes) {
            if (!(e instanceof OWLExistentialRestriction)) continue;
            existentialExists = true;
            OWLExistentialRestriction ex = (OWLExistentialRestriction)e;
            OWLAllValuesFrom closure = ClosureAxiomFactory.getClosureAxiom(namedClass, ex);
            if (!allValuesFrom.equals(closure)) continue;
            closed = true;
            break;
        }
        return existentialExists && closed;
    }

    public boolean isSufficientlyExpressive(RDFSNamedClass namedClass) {
        if (namedClass instanceof OWLNamedClass) {
            OWLNamedClass oc = (OWLNamedClass)namedClass;
            if (oc.getEquivalentClasses().size() > 1) {
                return false;
            }
            List classes = this.getParentClasses(namedClass);
            for (RDFSClass cls : classes) {
                if (cls instanceof OWLLogicalClass || cls instanceof OWLCardinalityBase) {
                    return false;
                }
                if (!(cls instanceof OWLAllValuesFrom) || this.isClosureAxiom(oc, classes, (OWLAllValuesFrom)cls)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSuitable(OWLModel owlModel) {
        return true;
    }
}

