/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleresource.tests;

import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.components.singleresource.SingleResourceComponent;

public class SingleResourceComponentTestCase
extends AbstractJenaTestCase {
    public void testActionsEnabled() {
        OWLNamedClass type = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty predicate = this.owlModel.createOWLObjectProperty("property");
        OWLIndividual individual = type.createOWLIndividual("Individual");
        SingleResourceComponent c = new SingleResourceComponent(predicate);
        c.setSubject(individual);
        SingleResourceComponentTestCase.assertTrue((boolean)c.isSetEnabled());
        SingleResourceComponentTestCase.assertTrue((boolean)c.isCreateEnabled());
        SingleResourceComponentTestCase.assertFalse((boolean)c.isRemoveEnabled());
        individual.setPropertyValue(predicate, this.owlThing);
        c.valuesChanged();
        SingleResourceComponentTestCase.assertTrue((boolean)c.isSetEnabled());
        SingleResourceComponentTestCase.assertTrue((boolean)c.isCreateEnabled());
        SingleResourceComponentTestCase.assertTrue((boolean)c.isRemoveEnabled());
    }

    public void testCreateButtonDisabledForEnumeratedClass() {
        OWLNamedClass type = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty predicate = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass enumClass = this.owlModel.createOWLNamedClass("Enum");
        OWLEnumeratedClass enumeration = this.owlModel.createOWLEnumeratedClass();
        enumeration.addOneOf(this.owlThing);
        enumeration.addOneOf(this.owlModel.getOWLNamedClassClass());
        predicate.setRange(enumClass);
        OWLIndividual individual = type.createOWLIndividual("Individual");
        SingleResourceComponent c = new SingleResourceComponent(predicate);
        c.setSubject(individual);
        SingleResourceComponentTestCase.assertTrue((boolean)c.isCreateEnabled());
        enumClass.setDefinition(enumeration);
        SingleResourceComponentTestCase.assertFalse((boolean)c.isCreateEnabled());
    }

    public void testHasValueRestrictions() {
        OWLNamedClass type = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty predicate = this.owlModel.createOWLObjectProperty("property");
        OWLIndividual individual = type.createOWLIndividual("Individual");
        type.addSuperclass(this.owlModel.createOWLHasValue(predicate, this.owlThing));
        SingleResourceComponent c = new SingleResourceComponent(predicate);
        c.setSubject(individual);
        c.valuesChanged();
        SingleResourceComponentTestCase.assertFalse((boolean)c.isSetEnabled());
        SingleResourceComponentTestCase.assertFalse((boolean)c.isCreateEnabled());
        SingleResourceComponentTestCase.assertFalse((boolean)c.isRemoveEnabled());
        SingleResourceComponentTestCase.assertEquals((Object)this.owlThing, (Object)c.getResource());
    }

    public void testSubpropertyValue() {
        OWLNamedClass type = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty predicate = this.owlModel.createOWLObjectProperty("superproperty");
        OWLObjectProperty subproperty = this.owlModel.createOWLObjectProperty("subproperty");
        subproperty.addSuperproperty(predicate);
        OWLIndividual subject = type.createOWLIndividual("Individual");
        subject.addPropertyValue(subproperty, this.owlThing);
        SingleResourceComponent c = new SingleResourceComponent(predicate);
        c.setSubject(subject);
        c.valuesChanged();
        SingleResourceComponentTestCase.assertEquals((Object)this.owlThing, (Object)c.getResource());
        SingleResourceComponentTestCase.assertTrue((boolean)c.isSetEnabled());
        SingleResourceComponentTestCase.assertTrue((boolean)c.isCreateEnabled());
        SingleResourceComponentTestCase.assertFalse((boolean)c.isRemoveEnabled());
    }
}

