/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLExistentialRestriction;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.util.ClosureAxiomFactory;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class AddClosureAxiomAction
extends ResourceAction {
    public AddClosureAxiomAction() {
        super("Add closure axiom", OWLIcons.getAllRestrictionIcon());
    }

    public void actionPerformed(ActionEvent e) {
        OWLSomeValuesFrom restriction = (OWLSomeValuesFrom)this.getResource();
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab(this.getComponent());
        OWLNamedClass editedCls = ((ConditionsTable)((Object)this.getComponent())).getEditedCls();
        AddClosureAxiomAction.performAction(editedCls, (OWLExistentialRestriction)restriction);
        if (tab != null) {
            tab.ensureClsSelected(editedCls, -1);
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        if (component instanceof ConditionsTable) {
            OWLNamedClass editedCls = ((ConditionsTable)((Object)component)).getEditedCls();
            return AddClosureAxiomAction.isSuitable((Frame)resource, editedCls);
        }
        return false;
    }

    public static boolean isSuitable(Frame frame, OWLNamedClass editedCls) {
        if (frame instanceof OWLSomeValuesFrom) {
            OWLNamedClass subCls;
            OWLNamedClass subclass;
            OWLAnonymousClass root;
            OWLSomeValuesFrom someRestriction = (OWLSomeValuesFrom)frame;
            if (editedCls.isEditable() && someRestriction.getOnProperty() instanceof OWLObjectProperty && ((root = someRestriction.getExpressionRoot()) instanceof OWLIntersectionClass ? (subclass = root.getOwner()) instanceof OWLNamedClass && root.isSubclassOf(subclass) && ((OWLIntersectionClass)root).getOperands().contains(someRestriction) : someRestriction.getSubclassCount() == 1 && (subCls = someRestriction.getOwner()) instanceof OWLNamedClass)) {
                return true;
            }
        }
        return false;
    }

    public static OWLAllValuesFrom performAction(OWLNamedClass namedClass, OWLSomeValuesFrom someValuesFrom) {
        return ClosureAxiomFactory.addClosureAxiom(namedClass, someValuesFrom);
    }

    public static OWLAllValuesFrom performAction(OWLNamedClass namedClass, OWLExistentialRestriction restriction) {
        return ClosureAxiomFactory.addClosureAxiom(namedClass, restriction);
    }
}

