/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;

class AddNamedClassAction
extends ResourceSelectionAction
implements ConditionsTableConstants {
    private ConditionsTable table;

    AddNamedClassAction(ConditionsTable table) {
        super("Add named class...", OWLIcons.getAddIcon("PrimitiveClass"));
        this.table = table;
    }

    public void resourceSelected(RDFResource resource) {
        OWLNamedClass editedCls = this.table.getEditedCls();
        this.table.selectNecessaryIfNothingSelected();
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this.table));
        int row = this.table.addRow((Cls)resource);
        if (tab != null) {
            tab.ensureClsSelected(editedCls, row);
        }
    }

    public Collection getSelectableResources() {
        Collection clses = this.table.getOWLModel().getUserDefinedOWLNamedClasses();
        clses.add(this.table.getOWLModel().getOWLThingClass());
        clses.remove(((OWLTableModel)this.table.getModel()).getEditedCls());
        ConditionsTableModel tableModel = (ConditionsTableModel)this.table.getModel();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            RDFSClass cls = tableModel.getClass(i);
            if (cls instanceof OWLNamedClass) {
                clses.remove(cls);
            }
            ++i;
        }
        Object[] cs = clses.toArray();
        Arrays.sort(cs, new FrameComparator());
        return clses;
    }

    public RDFResource pickResource() {
        return ProtegeUI.getSelectionDialogFactory().selectClass((Component)((Object)this.table), this.table.getOWLModel(), "Select a named class to add");
    }
}

