/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.ui.SelectInstancesPanel;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class SelectResourcesPanel
extends SelectInstancesPanel {
    private static final String DIRECT_ASSERTED = "Direct Asserted Instances";
    private static final String DIRECT_INFERRED = "Direct Inferred Instances";
    private static final String ALL_ASSERTED = "All Asserted Instances";
    private static final String ALL_INFERRED = "All Inferred Instances";
    private JComboBox classComboBox;
    private JComboBox instancesComboBox;

    public SelectResourcesPanel(OWLModel owlModel, Collection classes) {
        this(owlModel, classes, false);
    }

    public SelectResourcesPanel(OWLModel owlModel, Collection classes, boolean allowsMultipleSelection) {
        super((KnowledgeBase)owlModel, classes);
        if (!allowsMultipleSelection) {
            this._instanceList.setSelectionMode(0);
        }
    }

    protected LabeledComponent createClsesLabeledComponent(KnowledgeBase kb, Collection clses) {
        LabeledComponent lc = super.createClsesLabeledComponent(kb, clses);
        return lc;
    }

    protected JComponent createClsTree(Collection clses) {
        return super.createClsTree(clses);
    }

    protected JComboBox createDirectAllInstanceComboBox() {
        super.createDirectAllInstanceComboBox();
        this.instancesComboBox = ComponentFactory.createComboBox();
        this.instancesComboBox.addItem(DIRECT_ASSERTED);
        this.instancesComboBox.addItem(DIRECT_INFERRED);
        this.instancesComboBox.addItem(ALL_ASSERTED);
        this.instancesComboBox.addItem(ALL_INFERRED);
        this.instancesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SelectResourcesPanel.this.loadInstances();
            }
        });
        return this.instancesComboBox;
    }

    protected Collection getInstances(Cls cls) {
        Object selectedItem = this.instancesComboBox.getSelectedItem();
        if (DIRECT_INFERRED.equals(selectedItem)) {
            if (cls instanceof RDFSClass) {
                RDFSClass c = (RDFSClass)cls;
                return c.getInferredInstances(false);
            }
        } else {
            if (ALL_ASSERTED.equals(selectedItem)) {
                return cls.getInstances();
            }
            if (ALL_INFERRED.equals(selectedItem) && cls instanceof RDFSClass) {
                RDFSClass c = (RDFSClass)cls;
                return c.getInferredInstances(true);
            }
        }
        return cls.getDirectInstances();
    }
}

