/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Existential {
    public static List getExistentialDependents(OWLNamedClass cls, OWLObjectProperty property) {
        ArrayList result = new ArrayList();
        for (RDFSClass superClass : cls.getSuperclasses(true)) {
            if (superClass.getSuperclasses(false).contains(cls)) {
                if (superClass instanceof OWLIntersectionClass) {
                    Existential.getExistentialDependents(result, (OWLIntersectionClass)superClass, property);
                    continue;
                }
                Existential.perhapsAdd(result, superClass, property);
                continue;
            }
            Existential.perhapsAdd(result, superClass, property);
        }
        Collections.sort(result, new FrameComparator());
        return result;
    }

    private static void getExistentialDependents(List result, OWLIntersectionClass superclass, OWLObjectProperty property) {
        for (RDFSClass rdfsClass : superclass.getOperands()) {
            Existential.perhapsAdd(result, rdfsClass, property);
        }
    }

    private static void perhapsAdd(List result, RDFSClass superclass, OWLObjectProperty property) {
        RDFSClass c;
        OWLSomeValuesFrom someRestriction;
        RDFProperty restrictedProperty;
        if (superclass instanceof OWLSomeValuesFrom && (property.equals(restrictedProperty = (someRestriction = (OWLSomeValuesFrom)superclass).getOnProperty()) || restrictedProperty.getSuperproperties(true).contains(property)) && (c = (RDFSClass)someRestriction.getFiller()) instanceof OWLNamedClass && !result.contains(c)) {
            result.add(c);
            Collection supers = c.getSuperclasses(true);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (!supers.contains(it.next())) continue;
                it.remove();
            }
        }
    }

    public static OWLSomeValuesFrom getDirectExistentialRelation(OWLNamedClass parentClass, OWLObjectProperty property, OWLNamedClass childClass) {
        for (RDFSClass superclass : parentClass.getSuperclasses(false)) {
            OWLSomeValuesFrom someRestriction;
            if (!(superclass instanceof OWLSomeValuesFrom) || !(someRestriction = (OWLSomeValuesFrom)superclass).getOnProperty().equals(property) || !someRestriction.getFiller().equals(childClass)) continue;
            return someRestriction;
        }
        return null;
    }

    public static boolean isDirectExistentialDependent(OWLNamedClass parentClass, OWLObjectProperty property, OWLNamedClass childClass) {
        return Existential.getDirectExistentialRelation(parentClass, property, childClass) != null;
    }

    public static void removeExistentialDependent(OWLNamedClass parentClass, OWLObjectProperty property, OWLNamedClass childClass) {
        parentClass.removeSuperclass(Existential.getDirectExistentialRelation(parentClass, property, childClass));
    }
}

