/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer.filter.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.explorer.filter.DefaultExplorerFilter;

public class DefaultExplorerFilterTestCase
extends AbstractJenaTestCase {
    public void testAllowAllByDefault() {
        DefaultExplorerFilter filter = new DefaultExplorerFilter();
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLNamedClass("Other")));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLAllValuesFrom((RDFProperty)property, c)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, c)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLHasValue(property, c)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLCardinality(property, 1)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLMaxCardinality(property, 1)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLMinCardinality(property, 1)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLIntersectionClass()));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLUnionClass()));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLComplementClass(c)));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, this.owlModel.createOWLEnumeratedClass()));
    }

    public void testExistentialTree() {
        DefaultExplorerFilter filter = new DefaultExplorerFilter();
        filter.removeAllValidClasses();
        filter.addValidClass(OWLSomeValuesFrom.class);
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLNamedClass("Other")));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLAllValuesFrom((RDFProperty)property, c)));
        OWLNamedClass filler = c;
        OWLSomeValuesFrom someValuesFrom = this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, filler);
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, someValuesFrom));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLHasValue(property, c)));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLCardinality(property, 1)));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLMaxCardinality(property, 1)));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLMinCardinality(property, 1)));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLIntersectionClass()));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLUnionClass()));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLComplementClass(c)));
        DefaultExplorerFilterTestCase.assertFalse((boolean)filter.isValidChild(c, this.owlModel.createOWLEnumeratedClass()));
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(someValuesFrom, filler));
    }

    public void testExistentialTreeWithSubproperty() {
        DefaultExplorerFilter filter = new DefaultExplorerFilter();
        filter.removeAllValidClasses();
        filter.addValidClass(OWLSomeValuesFrom.class);
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        RDFProperty subproperty = this.owlModel.createSubproperty("sub", property);
        filter.setValidProperty(property);
        OWLSomeValuesFrom someValuesFrom = this.owlModel.createOWLSomeValuesFrom(subproperty, c);
        DefaultExplorerFilterTestCase.assertTrue((boolean)filter.isValidChild(c, someValuesFrom));
    }
}

