/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultIndividualFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class IndividualsTabClassesPanel
extends SelectableContainer {
    private ClassTree classTree;
    private OWLModel owlModel;

    public IndividualsTabClassesPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.add(this.createHeaderPanel(), "North");
        this.add(this.createClsesPanel(), "Center");
        this.setSelectable(this.classTree);
    }

    private JComponent createHeaderPanel() {
        JLabel label = ComponentFactory.createLabel((String)this.owlModel.getProject().getName());
        label.setIcon(Icons.getProjectIcon());
        String classBrowserLabel = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_TITLE);
        String forProjectLabel = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        HeaderComponent header = new HeaderComponent(classBrowserLabel, forProjectLabel, (JComponent)label);
        header.setColor(Colors.getClsColor());
        return header;
    }

    private JComponent createClsesPanel() {
        OWLNamedClass root = this.owlModel.getOWLThingClass();
        this.classTree = new ClassTree(null, (LazyTreeRoot)new ParentChildRoot((Cls)root));
        this.classTree.setLargeModel(true);
        FrameRenderer renderer = FrameRenderer.createInstance();
        renderer.setDisplayDirectInstanceCount(true);
        this.classTree.setCellRenderer((TreeCellRenderer)renderer);
        this.classTree.setSelectionRow(0);
        String classHiearchyLabel = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_HIERARCHY_LABEL);
        LabeledComponent c = new LabeledComponent(classHiearchyLabel, ComponentFactory.createScrollPane((JComponent)((Object)this.classTree)));
        c.setBorder(ComponentUtilities.getAlignBorder());
        c.addHeaderButton(this.getViewClsAction());
        FindInDialogAction fAction = new FindInDialogAction(new DefaultClassFind(this.owlModel, 1), Icons.getFindClsIcon(), this.classTree, true);
        ResourceFinder finder = new ResourceFinder(fAction);
        FindInDialogAction findIndAction = new FindInDialogAction(new DefaultIndividualFind(this.owlModel, 1), Icons.getFindIcon(), null, true);
        findIndAction.setTextBox(finder.getTextComponent());
        finder.addButton(findIndAction);
        c.setFooterComponent((JComponent)finder);
        return c;
    }

    public JTree getDropComponent() {
        return this.classTree;
    }

    private Action getViewClsAction() {
        return new ViewAction(ResourceKey.CLASS_VIEW, (Selectable)this){

            public void onView(Object o) {
                Cls cls = (Cls)o;
                IndividualsTabClassesPanel.this.owlModel.getProject().show((Instance)cls);
            }
        };
    }

    public void setSelectedCls(Cls cls) {
        if (cls instanceof RDFSNamedClass) {
            this.setSelectedClass((RDFSNamedClass)cls);
        }
    }

    public void setSelectedClass(RDFSNamedClass cls) {
        List path = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setSelectedObjectPath((JTree)((Object)this.classTree), (Collection)path);
    }
}

