/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.util.DoubleClickActionAdapter;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.TripleSelectable;
import edu.stanford.smi.protegex.owl.ui.components.TooltippedSelectableList;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class InstancesList
extends TooltippedSelectableList
implements TripleSelectable,
HostResourceDisplay {
    private List classes = Collections.EMPTY_LIST;

    public InstancesList(Action action) {
        this.setModel((ListModel)new SimpleListModel());
        if (action != null) {
            this.addMouseListener((MouseListener)new DoubleClickActionAdapter(action));
        }
        this.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        this.setFixedCellHeight(InstancesList.getHeight((Component)((Object)this)));
    }

    private static int getHeight(Component c) {
        return c.getFontMetrics(c.getFont()).getHeight() + 4;
    }

    public List getPrototypeTriples() {
        ArrayList<DefaultTriple> results = new ArrayList<DefaultTriple>();
        for (Object c : this.classes) {
            if (!(c instanceof RDFSNamedClass)) continue;
            RDFResource subject = (RDFResource)c;
            RDFProperty predicate = subject.getOWLModel().getRDFTypeProperty();
            results.add(new DefaultTriple(subject, predicate, null));
        }
        return results;
    }

    public List getSelectedTriples() {
        ArrayList<DefaultTriple> results = new ArrayList<DefaultTriple>();
        HashSet classesSet = new HashSet(this.classes);
        for (Object instance : this.getSelection()) {
            if (!(instance instanceof RDFResource)) continue;
            RDFResource object = (RDFResource)instance;
            RDFProperty predicate = object.getOWLModel().getRDFTypeProperty();
            Iterator types = object.listRDFTypes();
            while (types.hasNext()) {
                RDFSClass type = (RDFSClass)types.next();
                if (!classesSet.contains(type)) continue;
                results.add(new DefaultTriple(type, predicate, object));
            }
        }
        return results;
    }

    public void setClasses(Collection classes) {
        this.classes = new ArrayList(classes);
    }

    public void setSelectedTriples(Collection triples) {
        int i;
        HashSet<Integer> indices = new HashSet<Integer>();
        ListModel listModel = this.getModel();
        block0: for (Triple triple : triples) {
            i = 0;
            while (i < listModel.getSize()) {
                if (listModel.getElementAt(i).equals(triple.getObject())) {
                    indices.add(new Integer(i));
                    continue block0;
                }
                ++i;
            }
        }
        int[] sels = new int[indices.size()];
        Iterator it = indices.iterator();
        i = 0;
        while (it.hasNext()) {
            Integer integer = (Integer)it.next();
            sels[i] = integer;
            ++i;
        }
        this.setSelectedIndices(sels);
    }

    public boolean displayHostResource(RDFResource resource) {
        int i = this.getModel().getSize() - 1;
        while (i >= 0) {
            if (resource == this.getModel().getElementAt(i)) {
                this.setSelectedValue(resource);
                return true;
            }
            --i;
        }
        return false;
    }
}

