/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.ComponentFactory;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MultiSlotPanel
extends JPanel {
    private Cls cls;
    private BrowserSlotPattern pattern;
    private List panels = new ArrayList();

    public MultiSlotPanel(BrowserSlotPattern pattern, Cls cls) {
        this.cls = cls;
        this.pattern = pattern;
        this.createUI();
        this.loadUI();
    }

    private void createUI() {
        this.setLayout(new GridLayout(2, 10, 0, 4));
        this.add(ComponentFactory.createLabel((String)"Set display properties and optional text:"));
        Collection slots = this.cls.getVisibleTemplateSlots();
        JPanel panel = new JPanel(new FlowLayout());
        int i = 0;
        while (i < 5) {
            panel.add(this.createTextPanel());
            panel.add(this.createSlotPanel(slots));
            ++i;
        }
        panel.add(this.createTextPanel());
        this.add(panel);
    }

    private void loadUI() {
        if (this.pattern != null) {
            Iterator j = this.panels.iterator();
            Iterator i = this.pattern.getElements().iterator();
            while (i.hasNext() && j.hasNext()) {
                Object o = i.next();
                Object panel = j.next();
                if (o instanceof String) {
                    if (!(panel instanceof JTextField)) {
                        panel = j.next();
                    }
                    JTextField field = (JTextField)panel;
                    field.setText((String)o);
                    continue;
                }
                if (!(panel instanceof JComboBox)) {
                    panel = j.next();
                }
                JComboBox box = (JComboBox)panel;
                box.setSelectedItem(o);
            }
        }
    }

    private JComponent createTextPanel() {
        JTextField textField = ComponentFactory.createTextField();
        textField.setColumns(2);
        this.panels.add(textField);
        return textField;
    }

    private JComponent createSlotPanel(Collection slots) {
        JComboBox slotBox = ComponentFactory.createComboBox();
        slotBox.setRenderer(new FrameRenderer());
        ArrayList values = new ArrayList(slots);
        values.add(0, null);
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(values.toArray());
        slotBox.setModel(model);
        slotBox.setSelectedItem(null);
        this.panels.add(slotBox);
        return slotBox;
    }

    public BrowserSlotPattern getBrowserTextPattern() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object o : this.panels) {
            if (o instanceof JTextField) {
                JTextField textField = (JTextField)o;
                String text = textField.getText();
                if (text == null || text.length() <= 0) continue;
                elements.add(text);
                continue;
            }
            JComboBox box = (JComboBox)o;
            Object slot = box.getSelectedItem();
            if (slot == null) continue;
            elements.add(slot);
        }
        return new BrowserSlotPattern(elements);
    }
}

