/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.matrix;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.matrix.EditableMatrixColumn;
import edu.stanford.smi.protegex.owl.ui.matrix.SortableMatrixColumn;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AnnotationPropertyMatrixColumn
implements EditableMatrixColumn,
SortableMatrixColumn {
    private RDFProperty property;

    public AnnotationPropertyMatrixColumn(RDFProperty property) {
        this.property = property;
    }

    public RDFProperty getAnnotationProperty() {
        return this.property;
    }

    public TableCellRenderer getCellRenderer() {
        return new FrameRenderer(){

            public void load(Object value) {
                if (value instanceof RDFResource) {
                    RDFResource instance = (RDFResource)value;
                    value = instance.getPropertyValue(AnnotationPropertyMatrixColumn.this.property);
                }
                if (value == null) {
                    this.clear();
                } else {
                    super.load(value);
                }
            }
        };
    }

    public String getName() {
        return this.property.getName();
    }

    public int getWidth() {
        return 250;
    }

    public Comparator getSortComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                RDFResource a = (RDFResource)o1;
                RDFResource b = (RDFResource)o2;
                Object valueA = a.getPropertyValue(AnnotationPropertyMatrixColumn.this.property);
                Object valueB = b.getPropertyValue(AnnotationPropertyMatrixColumn.this.property);
                if (valueA instanceof Comparable) {
                    if (valueB == null) {
                        return -1;
                    }
                    int c = ((Comparable)valueA).compareTo(valueB);
                    if (c != 0) {
                        return c;
                    }
                } else if (valueB != null) {
                    return 1;
                }
                return a.getName().compareTo(b.getName());
            }
        };
    }

    public TableCellEditor getTableCellEditor() {
        JTextField textField = new JTextField();
        return new DefaultCellEditor(textField){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                RDFResource instance = (RDFResource)value;
                if ((value = instance.getPropertyValue(AnnotationPropertyMatrixColumn.this.property)) == null) {
                    value = "";
                }
                return super.getTableCellEditorComponent(table, instance.getLocalName(), isSelected, row, column);
            }
        };
    }

    public boolean isCellEditable(RDFResource instance) {
        return instance.getPropertyValues(this.property).size() < 2;
    }

    public void setValueAt(RDFResource instance, Object value) {
        if (((String)value).length() == 0) {
            value = null;
        }
        instance.setPropertyValue(this.property, value);
    }
}

