/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelOrderedWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SourceCodePanel
extends JPanel {
    private JTextArea textArea;
    private JCheckBox useXMLEntitiesBox;
    private JComboBox tripleStoreCombo;
    private OWLModel owlModel;

    public SourceCodePanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.setLayout(new BorderLayout());
        this.useXMLEntitiesBox = new JCheckBox("Use XML Entities", XMLWriterPreferences.getInstance().isUseNamespaceEntities());
        this.useXMLEntitiesBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourceCodePanel.this.writeSelectedTripleStore();
            }
        });
        ArrayList displayedTripleStores = new ArrayList(this.owlModel.getTripleStoreModel().getTripleStores());
        displayedTripleStores.remove(0);
        this.tripleStoreCombo = new JComboBox<Object>(displayedTripleStores.toArray());
        this.tripleStoreCombo.setSelectedItem(this.owlModel.getTripleStoreModel().getActiveTripleStore());
        this.tripleStoreCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SourceCodePanel.this.writeSelectedTripleStore();
            }
        });
        this.tripleStoreCombo.setRenderer(new TripleStoreListCellRenderer());
        JPanel panel = new JPanel(new BorderLayout(7, 7));
        panel.add((Component)this.tripleStoreCombo, "North");
        panel.add((Component)this.useXMLEntitiesBox, "South");
        this.add((Component)panel, "North");
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Courier New", 0, 12));
        JScrollPane rdfScrollPane = new JScrollPane(this.textArea);
        LabeledComponent lc = new LabeledComponent("Source Code", rdfScrollPane);
        this.add("Center", (Component)lc);
        this.setPreferredSize(new Dimension(760, 600));
        this.writeSelectedTripleStore();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SourceCodePanel.this.textArea.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    private void writeSelectedTripleStore() {
        StringWriter stringWriter = new StringWriter();
        XMLWriterPreferences.getInstance().setUseNamespaceEntities(this.useXMLEntitiesBox.isSelected());
        TripleStore ts = (TripleStore)this.tripleStoreCombo.getSelectedItem();
        OWLModelOrderedWriter writer = new OWLModelOrderedWriter(this.owlModel, ts, stringWriter);
        try {
            writer.write();
        }
        catch (IOException e) {
            ProtegeUI.getModalDialogFactory().showThrowable(this.owlModel, e);
        }
        String buffer = stringWriter.toString();
        this.textArea.setText(buffer);
    }

    private class TripleStoreListCellRenderer
    extends DefaultListCellRenderer {
        private TripleStoreListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            TripleStore ts = (TripleStore)value;
            String name = ts.getName();
            if (name == null) {
                name = "<Main File>";
            }
            label.setText(name);
            return label;
        }
    }
}

