/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.alldifferent;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadatatab.alldifferent.AllDifferentEditorPanel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.alldifferent.AllDifferentMemberChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AllDifferentSelectionPanel
extends JPanel
implements AllDifferentMemberChangedListener,
Disposable {
    private ClassListener clsListener = new ClassAdapter(){

        public void instanceAdded(RDFSClass cls, RDFResource instance) {
            AllDifferentSelectionPanel.this.listModel.addElement(instance);
        }

        public void instanceRemoved(RDFSClass cls, RDFResource instance) {
            AllDifferentSelectionPanel.this.listModel.removeElement(instance);
        }
    };
    private Action createAction = new AbstractAction("Create owl:AllDifferent", Icons.getCreateIcon()){

        public void actionPerformed(ActionEvent arg0) {
            OWLAllDifferent adi = AllDifferentSelectionPanel.this.owlModel.createOWLAllDifferent();
            AllDifferentSelectionPanel.this.list.setSelectedValue(adi, true);
        }
    };
    private Action deleteAction = new AbstractAction("Delete owl:AllDifferent", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLAllDifferent ali = (OWLAllDifferent)AllDifferentSelectionPanel.this.list.getSelectedValue();
            if (ali == null) {
                AllDifferentSelectionPanel.this.editorPanel.setIsAllDifferentItemSelected(false);
                ProtegeUI.getModalDialogFactory().showMessageDialog(AllDifferentSelectionPanel.this.owlModel, "Select an All-Different Element first", "No Item Selected");
                return;
            }
            ali.delete();
            AllDifferentSelectionPanel.this.editorPanel.setSelectedAllDifferentInstance(null);
        }
    };
    private AllDifferentEditorPanel editorPanel;
    private JList list;
    private DefaultListModel listModel;
    private OWLModel owlModel;
    private ListSelectionListener selectionListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            OWLAllDifferent adi = (OWLAllDifferent)AllDifferentSelectionPanel.this.list.getSelectedValue();
            if (adi != null) {
                AllDifferentSelectionPanel.this.editorPanel.setIsAllDifferentItemSelected(true);
                AllDifferentSelectionPanel.this.editorPanel.setSelectedAllDifferentInstance(adi);
                AllDifferentSelectionPanel.this.deleteAction.setEnabled(true);
            } else {
                AllDifferentSelectionPanel.this.editorPanel.setSelectedAllDifferentInstance(null);
                AllDifferentSelectionPanel.this.editorPanel.disableAddAction();
                AllDifferentSelectionPanel.this.deleteAction.setEnabled(false);
            }
        }
    };

    public AllDifferentSelectionPanel(OWLModel owlModel, AllDifferentEditorPanel editorPanel) {
        this.owlModel = owlModel;
        this.editorPanel = editorPanel;
        this.listModel = new DefaultListModel();
        Collection adis = owlModel.getOWLAllDifferents();
        for (OWLAllDifferent OWLAllDifferent2 : adis) {
            this.listModel.addElement(OWLAllDifferent2);
        }
        owlModel.getOWLAllDifferentClass().addClassListener(this.clsListener);
        this.deleteAction.setEnabled(false);
        this.list = new JList(this.listModel);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                OWLAllDifferent adi = (OWLAllDifferent)value;
                return super.getListCellRendererComponent((JList<?>)list, adi.getBrowserText(), index, isSelected, cellHasFocus);
            }
        });
        this.list.addListSelectionListener(this.selectionListener);
        JScrollPane scrollPane = new JScrollPane(this.list);
        LabeledComponent lc = new LabeledComponent("Sets of \"all different\" Individuals", scrollPane);
        lc.addHeaderButton(this.createAction);
        lc.addHeaderButton(this.deleteAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)lc);
    }

    public void dispose() {
        this.owlModel.getOWLAllDifferentClass().removeClassListener(this.clsListener);
    }

    protected void updateListUI() {
        this.list.updateUI();
    }

    public void allDifferentMemberChanged() {
        this.list.updateUI();
    }
}

