/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard;

import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AbstractImportStartWizardPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.FileImportEntry;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportVerificationPage;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import java.awt.Component;
import java.io.File;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileImportPage
extends AbstractImportStartWizardPage {
    private FileField fileField;
    private static final String HELP_TEXT = "<p>Please specify the local file that contains the ontology to be imported.</p>";

    public FileImportPage(ImportWizard wizard) {
        super("File import page", wizard);
        this.createUI();
    }

    private void createUI() {
        this.setHelpText("Importing an ontology contained in a specific file", HELP_TEXT);
        this.fileField = new FileField("Specify file path", "", "owl", "Select OWL or RDF files");
        this.fileField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FileImportPage.this.setPageComplete(FileImportPage.this.validateData());
            }
        });
        this.getContentComponent().add((Component)this.fileField, "North");
        this.setPageComplete(this.validateData());
    }

    private boolean validateData() {
        File f = this.fileField.getFilePath();
        if (f != null) {
            return f.isFile();
        }
        return false;
    }

    public void nextPressed() {
        this.addImportedOntology();
    }

    private void addImportedOntology() {
        File file = this.fileField.getFilePath();
        this.getImportWizard().getImportData().addImportEntry(new FileImportEntry(file));
    }

    public WizardPage getNextPage() {
        return new ImportVerificationPage(this.getImportWizard());
    }
}

