/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OWLDomainTable
extends SelectableTable {
    public static final int INFINITE_TIME = 1000000;

    public OWLDomainTable(final OWLDomainTableModel tableModel) {
        this.setModel(tableModel);
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        TableColumn owlColumn = this.getColumnModel().getColumn(0);
        ResourceRenderer renderer = new ResourceRenderer(){

            protected Icon getClsIcon(Cls cls) {
                if (tableModel.isInherited(cls)) {
                    ImageIcon icon = ((RDFSNamedClass)cls).getImageIcon();
                    return OWLIcons.getInheritedIcon(icon, "ClassFrame");
                }
                return super.getClsIcon(cls);
            }
        };
        owlColumn.setCellRenderer((TableCellRenderer)((Object)renderer));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    OWLDomainTable.this.handleDoubleClick();
                }
            }
        });
        this.addMouseListener((MouseListener)new PopupMenuMouseListener((JComponent)((Object)this)){

            protected JPopupMenu getPopupMenu() {
                int[] rows = OWLDomainTable.this.getSelectedRows();
                if (rows.length == 1) {
                    RDFSClass aClass = tableModel.getCls(rows[0]);
                    JPopupMenu menu = new JPopupMenu();
                    ResourceActionManager.addResourceActions(menu, (Component)((Object)OWLDomainTable.this), (RDFResource)aClass);
                    return menu;
                }
                return null;
            }

            protected void setSelection(JComponent c, int x, int y) {
                int row = y / OWLDomainTable.this.getRowHeight();
                if (row >= 0 && row < OWLDomainTable.this.getRowCount()) {
                    OWLDomainTable.this.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
    }

    public String getToolTipText(MouseEvent event) {
        ToolTipManager.sharedInstance().setDismissDelay(1000000);
        int rowCount = this.getModel().getRowCount();
        int i = 0;
        while (i < rowCount) {
            Rectangle r = this.getCellRect(i, 0, false);
            r.setSize(this.getWidth(), r.height);
            if (r.contains(event.getPoint())) {
                RDFResource res = (RDFResource)this.getModel().getValueAt(i, 0);
                return OWLUI.getOWLToolTipText(res);
            }
            ++i;
        }
        return null;
    }

    protected void configureEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            scrollPane.getViewport().setScrollMode(2);
            scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
    }

    public Collection getSelection() {
        OWLDomainTableModel tableModel = (OWLDomainTableModel)this.getModel();
        RDFProperty property = tableModel.getSlot();
        if (property != null) {
            return super.getSelection();
        }
        return Collections.EMPTY_LIST;
    }

    private void handleDoubleClick() {
        Cls cls;
        OWLDomainTableModel tableModel = (OWLDomainTableModel)this.getModel();
        int row = this.getSelectedRow();
        if (row >= 0 && row < tableModel.getRowCount() && (cls = (Cls)tableModel.getValueAt(row, 0)) != null) {
            tableModel.getSlot().getProject().show((Instance)cls);
        }
    }
}

