/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractLocalRepository;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.repository.AbstractRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.RepositoryEntryLabel;
import edu.stanford.smi.protegex.owl.ui.repository.action.RepositoryAction;
import edu.stanford.smi.protegex.owl.ui.repository.action.RepositoryActionManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RepositoryPanel
extends JPanel {
    private OWLModel owlModel;
    private RepositoryManager manager;
    private Repository repository;
    private AbstractRepositoriesPanel manPanel;
    private JComponent entryHolderPanel;
    private Action removeAction;
    private Action bumpUpAction;
    private Action bumpDownAction;
    private JCheckBox forceReadOnlyCheckBox;
    private LabeledComponent lc;
    private boolean collapsed = false;
    private Set importedOntologies;

    public RepositoryPanel(OWLModel model, RepositoryManager man, Repository rep, AbstractRepositoriesPanel manPan) {
        this.owlModel = model;
        this.manager = man;
        this.repository = rep;
        this.manPanel = manPan;
        this.importedOntologies = this.owlModel.getAllImports();
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        JPanel holderPanel = new JPanel(new BorderLayout(2, 2));
        holderPanel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
        this.entryHolderPanel = new JPanel();
        this.entryHolderPanel.setOpaque(false);
        holderPanel.add(this.entryHolderPanel);
        this.lc = new LabeledComponent(rep.getRepositoryDescription(), (Component)holderPanel);
        this.entryHolderPanel.setLayout(new BoxLayout(this.entryHolderPanel, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this.lc);
        this.removeAction = new AbstractAction("Remove", OWLIcons.getRemoveIcon()){

            public void actionPerformed(ActionEvent e) {
                RepositoryPanel.this.manager.remove(RepositoryPanel.this.repository);
                RepositoryPanel.this.manPanel.reloadUI();
            }
        };
        this.bumpUpAction = new AbstractAction("Move up", OWLIcons.getUpIcon()){

            public void actionPerformed(ActionEvent e) {
                RepositoryPanel.this.manager.moveUp(RepositoryPanel.this.repository);
                RepositoryPanel.this.manPanel.reloadUI();
            }
        };
        this.bumpDownAction = new AbstractAction("Move down", OWLIcons.getDownIcon()){

            public void actionPerformed(ActionEvent e) {
                RepositoryPanel.this.manager.moveDown(RepositoryPanel.this.repository);
                RepositoryPanel.this.manPanel.reloadUI();
            }
        };
        if (this.repository instanceof AbstractLocalRepository && !this.repository.isSystem()) {
            this.forceReadOnlyCheckBox = new JCheckBox("Force Read-Only");
            this.forceReadOnlyCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AbstractLocalRepository localRepository = (AbstractLocalRepository)RepositoryPanel.this.repository;
                    localRepository.setForceReadOnly(RepositoryPanel.this.forceReadOnlyCheckBox.isSelected());
                }
            });
            this.forceReadOnlyCheckBox.setSelected(((AbstractLocalRepository)this.repository).isForceReadOnly());
            holderPanel.add((Component)this.forceReadOnlyCheckBox, "North");
        }
        this.lc.addHeaderButton(this.bumpUpAction);
        this.lc.addHeaderButton(this.bumpDownAction);
        this.lc.addHeaderButton(this.removeAction);
        this.lc.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 1 && new Rectangle(0, 0, 20, 20).contains(e.getPoint())) {
                    RepositoryPanel.this.collapsed = !RepositoryPanel.this.collapsed;
                    RepositoryPanel.this.refreshList();
                }
                if (e.isPopupTrigger()) {
                    RepositoryPanel.this.showRepositoryActionMenu(e);
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RepositoryPanel.this.showRepositoryActionMenu(e);
                }
            }
        });
        this.lc.setOpaque(false);
        this.removeAction.setEnabled(!this.repository.isSystem());
        this.refreshList();
        this.setNotOpaque(this);
    }

    private void showRepositoryActionMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        RepositoryActionManager actionMan = RepositoryActionManager.getInstance();
        for (final RepositoryAction curAction : actionMan.getActions(this.repository, this.owlModel)) {
            menu.add(new AbstractAction(curAction.getName()){

                public void actionPerformed(ActionEvent e) {
                    curAction.actionPerformed(RepositoryPanel.this.repository, RepositoryPanel.this.manPanel, RepositoryPanel.this.owlModel);
                }
            });
        }
        menu.show((Component)this.lc, e.getX(), e.getY());
    }

    private void refreshList() {
        Icon icon;
        this.entryHolderPanel.removeAll();
        UIDefaults uiDefaults = UIManager.getLookAndFeel().getDefaults();
        if (this.collapsed) {
            icon = uiDefaults.getIcon("Tree.collapsedIcon");
        } else {
            icon = uiDefaults.getIcon("Tree.expandedIcon");
            TreeSet ts = new TreeSet(this.repository.getOntologies());
            for (URI uri : ts) {
                boolean imported = false;
                if (this.importedOntologies.contains(uri.toString())) {
                    imported = this.manager.getRepository(uri) == this.repository;
                }
                this.entryHolderPanel.add(new RepositoryEntryLabel(this.owlModel, uri, this.repository.getOntologyLocationDescription(uri), imported));
            }
        }
        this.lc.setHeaderIcon(icon);
        this.setNotOpaque(this);
        this.manPanel.revalidate();
    }

    private void setNotOpaque(JComponent c) {
        c.setOpaque(false);
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            Component curComp = components[i];
            if (curComp instanceof JComponent) {
                this.setNotOpaque((JComponent)curComp);
            }
            ++i;
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(Color.GRAY);
        g.drawLine(3, this.getHeight() - 1, this.getWidth() - 3, this.getHeight() - 1);
        g.setColor(oldColor);
    }
}

