/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.search.FindUsage;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import java.util.Collection;

public class FindUsageAsSuperclassTestCase
extends AbstractJenaTestCase {
    public void testFindSuperclassUsage() {
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass searchCls = this.owlModel.createOWLNamedClass("Search");
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(this.owlModel.createOWLComplementClass(searchCls));
        unionCls.addOperand(this.owlModel.createOWLComplementClass(searchCls));
        hostCls.addSuperclass(unionCls);
        Collection items = FindUsage.getItems(searchCls);
        FindUsageAsSuperclassTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsSuperclassTestCase.assertEquals((Object)hostCls, (Object)item.host);
        FindUsageAsSuperclassTestCase.assertEquals((Object)unionCls, (Object)item.usage);
        FindUsageAsSuperclassTestCase.assertEquals((int)0, (int)item.type);
    }

    public void testFindEquivalentClassUsage() {
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass searchCls = this.owlModel.createOWLNamedClass("Search");
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(this.owlModel.createOWLComplementClass(searchCls));
        unionCls.addOperand(this.owlModel.createOWLComplementClass(searchCls));
        hostCls.addEquivalentClass(unionCls);
        Collection items = FindUsage.getItems(searchCls);
        FindUsageAsSuperclassTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsSuperclassTestCase.assertEquals((Object)hostCls, (Object)item.host);
        FindUsageAsSuperclassTestCase.assertEquals((Object)unionCls, (Object)item.usage);
        FindUsageAsSuperclassTestCase.assertEquals((int)1, (int)item.type);
    }
}

