/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreeNode;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreePanel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class InferredSubsumptionTreePanel
extends SubsumptionTreePanel {
    private Action assertAction = new AbstractAction("Assert selected change(s)", OWLIcons.getAssertChangeIcon()){

        public void actionPerformed(ActionEvent e) {
            InferredSubsumptionTreePanel.this.assertSelectedChange();
        }
    };
    private Action displayChangedAction = new AbstractAction("Display changed classes in list", OWLIcons.getDisplayChangedClassesIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)InferredSubsumptionTreePanel.this));
            if (tab != null) {
                tab.refreshChangedClses();
            }
        }
    };
    private Action saveInferredAction = new AbstractAction("Save inferred version as file...", OWLIcons.getSaveInferredIcon()){

        public void actionPerformed(ActionEvent e) {
            InferredSubsumptionTreePanel.this.saveInferred();
        }
    };
    private static final String TITLE = "Inferred Hierarchy";

    public InferredSubsumptionTreePanel(OWLModel owlModel) {
        super(owlModel.getOWLThingClass(), (Slot)((AbstractOWLModel)owlModel).getProtegeInferredSubclassesProperty(), ((AbstractOWLModel)owlModel).getProtegeInferredSuperclassesProperty(), true);
        this.assertAction.setEnabled(false);
        this.getLabeledComponent().addHeaderButton(this.assertAction);
        this.getLabeledComponent().addHeaderButton(this.displayChangedAction);
        this.getLabeledComponent().addHeaderButton(this.saveInferredAction);
    }

    private void assertSelectedChange() {
        OWLNamedClass cls = this.getSelectedCls();
        OWLModel owlModel = this.getOWLModel();
        ChangedClassesPanel ccp = ChangedClassesPanel.get(owlModel);
        try {
            try {
                owlModel.beginTransaction("Assert change for " + cls.getBrowserText());
                ccp.getTableModel().assertChange(cls);
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    public Hierarchy createClone() {
        return new InferredSubsumptionTreePanel(this.getOWLModel());
    }

    protected ClassTree createSelectableTree(Action viewAction, LazyTreeRoot root) {
        return new InferredChangesClassTree(viewAction, root);
    }

    protected Action createViewClsAction() {
        return new AbstractAction("View class", OWLIcons.getViewIcon()){

            public void actionPerformed(ActionEvent e) {
                Collection selection = InferredSubsumptionTreePanel.this.getSelection();
                if (!selection.isEmpty()) {
                    Cls cls = (Cls)selection.iterator().next();
                    cls.getProject().show((Instance)cls);
                }
            }
        };
    }

    public String getTitle() {
        return TITLE;
    }

    public void navigateToResource(RDFResource resource) {
        if (resource instanceof RDFSClass) {
            this.setSelectedClass((RDFSClass)resource);
        }
    }

    private void saveInferred() {
        JFileChooser fileChooser = new JFileChooser(".");
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = fileChooser.getSelectedFile();
            OWLModel owlModel = this.getOWLModel();
            ArrayList<OWLNamedClass> clses = new ArrayList<OWLNamedClass>();
            for (OWLNamedClass cls : owlModel.getUserDefinedOWLNamedClasses()) {
                if (cls.isProbeClass()) continue;
                clses.add(cls);
            }
            String baseURI = owlModel.getNamespaceManager().getDefaultNamespace();
            if (baseURI.endsWith("#")) {
                baseURI = baseURI.substring(0, baseURI.length() - 1);
            }
            OntModel ontModel = new JenaCreator(owlModel, false, true, clses, new ModalProgressBarManager("Preparing File")).createOntModel();
            try {
                String ns = owlModel.getNamespaceManager().getDefaultNamespace();
                Ontology ontology = Jena.getDefaultJenaOntology(ns, ontModel);
                ontology.addProperty(OWL.versionInfo, (RDFNode)ontModel.createTypedLiteral("classified"));
                JenaOWLModel.save(file, ontModel, "RDF/XML-ABBREV", ns);
                ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Successfully saved to " + file + ".");
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                ProtegeUI.getModalDialogFactory().showThrowable(owlModel, ex);
            }
        }
    }

    protected void updateActions() {
        super.updateActions();
        OWLNamedClass cls = this.getSelectedCls();
        this.assertAction.setEnabled(cls != null && cls.getClassificationStatus() == 3 && ChangedClassesPanel.get(this.getOWLModel()).getTableModel().contains(cls));
    }

    private class InferredChangesClassTree
    extends ClassTree {
        public InferredChangesClassTree(Action viewAction, LazyTreeRoot root) {
            super(viewAction, root);
            RDFProperty property = InferredSubsumptionTreePanel.this.getOWLModel().getRDFProperty("protege:inferredSubclassOf");
            this.setCellRenderer((TreeCellRenderer)((Object)new MovedResourcesRenderer(property)));
        }

        public String getToolTipText(MouseEvent event) {
            String str = null;
            int row = this.getRowForLocation(event.getX(), event.getY());
            TreePath path = this.getPathForRow(row);
            if (path != null && path.getPathCount() > 0) {
                SubsumptionTreeNode node = (SubsumptionTreeNode)((Object)path.getLastPathComponent());
                RDFSClass cls = (RDFSClass)node.getCls();
                ChangedClassesPanel ccp = ChangedClassesPanel.get(InferredSubsumptionTreePanel.this.getOWLModel());
                str = ccp.getChangeText(cls);
                if (str == null) {
                    str = OWLUI.getOWLToolTipText(cls);
                }
            }
            return str;
        }
    }

    private class MovedResourcesRenderer
    extends ResourceRenderer {
        public MovedResourcesRenderer(Slot directSuperclassesSlot) {
            super(directSuperclassesSlot);
        }

        protected Color getTextColor() {
            ChangedClassesPanel ccp = ChangedClassesPanel.get(InferredSubsumptionTreePanel.this.getOWLModel());
            if (ccp.contains(this.loadedClass)) {
                return Color.blue;
            }
            return super.getTextColor();
        }
    }
}

