/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractTreeWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.ToggleSuperclassExplorerAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResultsViewModelFind;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreeNode;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreeRoot;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class SubsumptionTreePanel
extends SelectableContainer
implements Hierarchy,
ClassTreePanel {
    private HeaderComponent headerComponent;
    private LabeledComponent lc;
    private OWLModel owlModel;
    private static final int MAX_EXPANSIONS = 100;
    private Slot superclassesSlot;
    private Action viewAction;
    public static final String TYPE = "Subclass Explorer";

    public SubsumptionTreePanel(Cls root, Slot subclassesSlot, Slot superclassesSlot, boolean useInferredSuperclasses) {
        this(new SubsumptionTreeRoot(root, subclassesSlot), superclassesSlot, useInferredSuperclasses);
    }

    public SubsumptionTreePanel(LazyTreeRoot treeRoot, Slot superclassesSlot, boolean useInferredSuperclasses) {
        this(treeRoot, superclassesSlot, useInferredSuperclasses, new DefaultClassFind((OWLModel)superclassesSlot.getKnowledgeBase(), 1));
    }

    public SubsumptionTreePanel(LazyTreeRoot treeRoot, Slot superclassesSlot, boolean useInferredSuperclasses, ResultsViewModelFind findAlg) {
        this.superclassesSlot = superclassesSlot;
        this.setPreferredSize(new Dimension(260, 400));
        this.setMinimumSize(new Dimension(100, 100));
        this.owlModel = (OWLModel)superclassesSlot.getKnowledgeBase();
        this.viewAction = this.createViewClsAction();
        ClassTree tree = this.createSelectableTree(this.viewAction, treeRoot);
        tree.setLargeModel(true);
        tree.setSelectionRow(0);
        tree.setAutoscrolls(true);
        this.setSelectable(tree);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)new JScrollPane((Component)((Object)tree)), "Center");
        FindInDialogAction fAction = new FindInDialogAction(findAlg, Icons.getFindClsIcon(), tree, true);
        ResourceFinder finder = new ResourceFinder(fAction);
        mainPanel.add((Component)finder, "South");
        finder.addButton(new ToggleSuperclassExplorerAction(this, useInferredSuperclasses));
        this.lc = new LabeledComponent(this.getTitle(), (Component)mainPanel, true);
        WidgetUtilities.addViewButton(this.lc, this.viewAction);
        tree.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                SubsumptionTreePanel.this.updateActions();
            }
        });
        JLabel label = ComponentFactory.createLabel((String)this.owlModel.getProject().getName(), (Icon)Icons.getProjectIcon(), (int)2);
        this.headerComponent = new HeaderComponent("CLASS BROWSER", "For Project", (JComponent)label);
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.headerComponent);
        this.add("Center", (Component)this.lc);
        tree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)tree)){

            public JPopupMenu getPopupMenu() {
                return SubsumptionTreePanel.this.getPopupMenu();
            }
        });
    }

    protected JPopupMenu createPopupMenu(Cls cls) {
        JPopupMenu menu = new JPopupMenu();
        if (cls instanceof RDFResource) {
            ResourceActionManager.addResourceActions(menu, (Component)((Object)this), (RDFResource)cls);
        }
        return menu;
    }

    protected ClassTree createSelectableTree(Action viewAction, LazyTreeRoot root) {
        ClassTree tree = new ClassTree(viewAction, root);
        tree.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer(this.superclassesSlot)));
        return tree;
    }

    protected Action createViewClsAction() {
        return new ViewAction("View selected class", this){

            public void onView(Object o) {
                SubsumptionTreePanel.this.owlModel.getProject().show((Instance)((Cls)o));
            }
        };
    }

    public void expandRoot() {
        this.setExpandedCls(this.owlModel.getOWLThingClass(), true);
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JTree getClsesTree() {
        return this.getTree();
    }

    public Cls getDisplayParent() {
        TreePath path = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
        Object o = node.getUserObject();
        return o instanceof Cls ? (Cls)o : null;
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    private Action getHideClassAction() {
        return new AbstractAction("Hide class", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : SubsumptionTreePanel.this.getSelection()) {
                    cls.setVisible(false);
                }
            }
        };
    }

    protected LabeledComponent getLabeledComponent() {
        return this.lc;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    public List getPathToRoot(OWLNamedClass cls) {
        return this.getPathToRoot(cls, new LinkedList());
    }

    private List getPathToRoot(OWLNamedClass cls, LinkedList list) {
        list.add(0, cls);
        OWLNamedClass rootCls = cls.getOWLModel().getOWLThingClass();
        List superclasses = cls.getDirectOwnSlotValues(this.superclassesSlot);
        for (Cls superclass : superclasses) {
            if (superclass.equals(rootCls)) {
                list.add(0, superclass);
                return list;
            }
            if (!cls.isVisible() || !(superclass instanceof OWLNamedClass)) continue;
            this.getPathToRoot((OWLNamedClass)superclass, list);
            break;
        }
        return list;
    }

    public Collection getPathsToRoot(OWLNamedClass cls) {
        ArrayList results = new ArrayList();
        this.getPathsToRoot(cls, new LinkedList(), results);
        return results;
    }

    private void getPathsToRoot(OWLNamedClass cls, List list, Collection lists) {
        list.add(0, cls);
        OWLNamedClass rootCls = cls.getOWLModel().getOWLThingClass();
        List superclasses = cls.getDirectOwnSlotValues(this.superclassesSlot);
        for (Cls superclass : superclasses) {
            ArrayList<Cls> copy;
            if (superclass.equals(rootCls)) {
                copy = new ArrayList<Cls>(list);
                copy.add(0, superclass);
                lists.add(copy);
                continue;
            }
            if (!cls.isVisible() || !(superclass instanceof OWLNamedClass) || list.contains(superclass)) continue;
            copy = new ArrayList(list);
            this.getPathsToRoot((OWLNamedClass)superclass, copy, lists);
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu menu = null;
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)selection);
            menu = this.createPopupMenu(cls);
        }
        return menu;
    }

    public RDFSClass getSelectedClass() {
        return this.getSelectedCls();
    }

    OWLNamedClass getSelectedCls() {
        TreePath path;
        SubsumptionTreeNode node;
        JTree tree = this.getTree();
        if (tree.getSelectionCount() == 1 && (node = (SubsumptionTreeNode)((Object)(path = tree.getSelectionPath()).getLastPathComponent())).getCls() instanceof OWLNamedClass) {
            return (OWLNamedClass)node.getCls();
        }
        return null;
    }

    public String getType() {
        return TYPE;
    }

    public JTree getTree() {
        return (JTree)this.getSelectable();
    }

    private Action getUnhideClassAction() {
        return new AbstractAction("Make class visible", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent event) {
                for (Cls cls : SubsumptionTreePanel.this.getSelection()) {
                    cls.setVisible(true);
                }
            }
        };
    }

    public boolean isDefaultSynchronized() {
        return true;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setDisplayParent(Cls cls) {
        AbstractTreeWidget.setDisplayParent((JTree)this.getTree(), (Object)cls);
    }

    public void setExpandedCls(Cls cls, boolean expanded) {
        List path = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)path, (boolean)expanded);
    }

    public void setFinderComponent(JComponent c) {
        this.add(c, "South");
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)renderer);
    }

    public void setSelectedClass(RDFSClass cls) {
        if (!this.getSelection().contains(cls)) {
            if (cls instanceof OWLNamedClass) {
                Collection paths = this.getPathsToRoot((OWLNamedClass)cls);
                JTree tree = this.getTree();
                TreePath[] array = new TreePath[paths.size()];
                int i = 0;
                for (List list : paths) {
                    TreePath path;
                    array[i] = path = ComponentUtilities.getTreePath((JTree)tree, (Collection)list);
                    if (i == 0) {
                        tree.scrollPathToVisible(path);
                        tree.updateUI();
                    }
                    ++i;
                }
                tree.setSelectionPaths(array);
            } else {
                List path = ModelUtilities.getPathToRoot((Cls)cls);
                ComponentUtilities.setSelectedObjectPath((JTree)this.getTree(), (Collection)path);
            }
        }
    }

    public String toString() {
        return "SubsumptionTreePanel";
    }

    protected void updateActions() {
    }

    public static interface SuperClsesPanel {
        public void setCls(OWLNamedClass var1);
    }
}

