/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

public class TooltippedSelectableTree
extends SelectableTree {
    public TooltippedSelectableTree(Action doubleClickAction, LazyTreeRoot root) {
        super(doubleClickAction, root);
        final int oldDelay = ToolTipManager.sharedInstance().getDismissDelay();
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(oldDelay);
            }
        });
        this.setToolTipText("");
    }

    public String getToolTipText(MouseEvent event) {
        TreePath path;
        int row = this.getRowForLocation(event.getX(), event.getY());
        if (row >= 0 && (path = this.getPathForRow(row)) != null) {
            Object last = path.getLastPathComponent();
            RDFResource res = null;
            if (last instanceof LazyTreeNode) {
                LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
                res = (RDFResource)node.getUserObject();
            }
            if (res != null) {
                ToolTipManager.sharedInstance().setDismissDelay(1000000);
                return OWLUI.getOWLToolTipText(res);
            }
        }
        return null;
    }
}

