/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget.tests;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyValuesWidget;
import java.util.ArrayList;
import java.util.Collections;

public class WidgetConstraintViolationsTestCase
extends AbstractJenaTestCase {
    public void testMaxCardinality() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty predicate = this.owlModel.createOWLDatatypeProperty("property");
        RDFResource subject = cls.createInstance("instance");
        WidgetConstraintViolationsTestCase.assertFalse((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, Collections.EMPTY_LIST));
        cls.addSuperclass(this.owlModel.createOWLMaxCardinality(predicate, 1));
        ArrayList<String> values = new ArrayList<String>();
        WidgetConstraintViolationsTestCase.assertFalse((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, values));
        values.add("A");
        WidgetConstraintViolationsTestCase.assertFalse((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, values));
        values.add("B");
        WidgetConstraintViolationsTestCase.assertTrue((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, values));
    }

    public void testMinCardinality() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Class");
        OWLDatatypeProperty predicate = this.owlModel.createOWLDatatypeProperty("property");
        RDFResource subject = cls.createInstance("instance");
        WidgetConstraintViolationsTestCase.assertFalse((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, Collections.EMPTY_LIST));
        cls.addSuperclass(this.owlModel.createOWLMinCardinality(predicate, 2));
        ArrayList<String> values = new ArrayList<String>();
        WidgetConstraintViolationsTestCase.assertTrue((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, values));
        values.add("A");
        WidgetConstraintViolationsTestCase.assertTrue((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, values));
        values.add("B");
        WidgetConstraintViolationsTestCase.assertFalse((boolean)AbstractPropertyValuesWidget.isInvalid(subject, predicate, values));
    }
}

