/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.db.rdf.model.i;

import edu.stanford.db.rdf.model.i.ResourceImpl;
import edu.stanford.db.rdf.model.i.StatementImpl;
import edu.stanford.db.xml.util.QName;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.rdf.model.ModelException;
import org.w3c.rdf.model.NodeFactory;
import org.w3c.rdf.model.RDFNode;
import org.w3c.rdf.model.Resource;
import org.w3c.rdf.model.Statement;

public class FindIndex {
    protected boolean DEBUG = false;
    Comparator spoComparator = new SPOComparator();
    Comparator opComparator = new OPComparator();
    Comparator pComparator = new PComparator();
    ResourceImpl MAX_RES;
    TreeMap spoIdx;
    TreeMap pIdx;
    TreeMap opIdx;
    int useIdx;

    public FindIndex(NodeFactory nodeFactory, int n) {
        this.useIdx = n;
        this.MAX_RES = new ResourceImpl();
        this.MAX_RES.qname = new QName("<MAX>", null);
        if ((n & 1) != 0) {
            this.spoIdx = new TreeMap(new SPOComparator());
        }
        if ((n & 4) != 0) {
            this.pIdx = new TreeMap(new PComparator());
        }
        if ((n & 2) != 0) {
            this.opIdx = new TreeMap(new OPComparator());
        }
    }

    public void addLookup(Statement statement) {
        this.put(this.spoIdx, statement);
        this.put(this.opIdx, statement);
        this.put(this.pIdx, statement);
    }

    int compareNodes(RDFNode rDFNode, RDFNode rDFNode2) {
        int n;
        if (rDFNode == null || rDFNode2 == this.MAX_RES) {
            return -1;
        }
        if (rDFNode2 == null || rDFNode == this.MAX_RES) {
            return 1;
        }
        int n2 = rDFNode.hashCode();
        if (n2 < (n = rDFNode2.hashCode())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    Iterator get(SortedMap sortedMap, Statement statement) throws ModelException {
        return new PrefixIterator(statement, sortedMap);
    }

    public int getUsedIndexes() {
        return this.useIdx;
    }

    RDFNode limitNode(RDFNode rDFNode) {
        return rDFNode == null ? this.MAX_RES : rDFNode;
    }

    Resource limitResource(Resource resource) {
        return resource == null ? this.MAX_RES : resource;
    }

    public Iterator multiget(Resource resource, Resource resource2, RDFNode rDFNode) throws ModelException {
        StatementImpl statementImpl = new StatementImpl();
        statementImpl.s = resource;
        statementImpl.p = resource2;
        statementImpl.o = rDFNode;
        if (this.DEBUG) {
            System.err.println("FIND FOR " + statementImpl + ":");
        }
        if (resource == null) {
            if (rDFNode == null) {
                if (this.DEBUG) {
                    System.err.println("USING p");
                }
                return this.get(this.pIdx, statementImpl);
            }
            return this.get(this.opIdx, statementImpl);
        }
        if (resource2 == null) {
            statementImpl.o = null;
        }
        if (this.DEBUG) {
            System.err.println("USING spo");
        }
        return this.get(this.spoIdx, statementImpl);
    }

    void put(Map map, Statement statement) {
        Object v = map.get(statement);
        if (v == null) {
            map.put(statement, statement);
        } else if (v instanceof Statement) {
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(v);
            hashSet.add(statement);
            map.put(statement, hashSet);
        } else {
            ((Set)v).add(statement);
        }
    }

    void remove(Map map, Statement statement) {
        Object v = map.get(statement);
        if (v == null) {
            return;
        }
        if (v instanceof Statement) {
            map.remove(statement);
        } else {
            Set set = (Set)v;
            set.remove(statement);
            if (set.size() == 0) {
                map.remove(statement);
            }
        }
    }

    public void removeLookup(Statement statement) {
        this.remove(this.spoIdx, statement);
        this.remove(this.opIdx, statement);
        this.remove(this.pIdx, statement);
    }

    public int size() {
        return this.spoIdx.size();
    }

    private class SPOComparator
    implements Comparator {
        SPOComparator() {
        }

        public int compare(Object object, Object object2) {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            try {
                int n = 0;
                Resource resource = statement.subject();
                Resource resource2 = statement2.subject();
                n = FindIndex.this.compareNodes(resource, resource2);
                if (n == 0 && (n = FindIndex.this.compareNodes(resource = statement.predicate(), resource2 = statement2.predicate())) == 0) {
                    n = FindIndex.this.compareNodes(statement.object(), statement2.object());
                }
                if (FindIndex.this.DEBUG) {
                    System.err.println("Comparing " + object + " and\n" + "          " + object2 + " = " + n);
                }
                return n;
            }
            catch (ModelException modelException) {
                return 0;
            }
        }

        public boolean equals(Object object) {
            return object instanceof SPOComparator;
        }
    }

    private class PComparator
    implements Comparator {
        PComparator() {
        }

        public int compare(Object object, Object object2) {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            try {
                int n = 0;
                Resource resource = statement.predicate();
                Resource resource2 = statement2.predicate();
                n = FindIndex.this.compareNodes(resource, resource2);
                if (n != 0) {
                    return n;
                }
                if (statement2.subject() == FindIndex.this.MAX_RES) {
                    return -1;
                }
                if (statement.subject() == FindIndex.this.MAX_RES) {
                    return 1;
                }
                return 0;
            }
            catch (ModelException modelException) {
                return 0;
            }
        }

        public boolean equals(Object object) {
            return object instanceof PComparator;
        }
    }

    private class OPComparator
    implements Comparator {
        OPComparator() {
        }

        public int compare(Object object, Object object2) {
            Statement statement = (Statement)object;
            Statement statement2 = (Statement)object2;
            try {
                int n = 0;
                RDFNode rDFNode = statement.object();
                RDFNode rDFNode2 = statement2.object();
                n = FindIndex.this.compareNodes(rDFNode, rDFNode2);
                if (n != 0) {
                    return n;
                }
                rDFNode = statement.predicate();
                n = FindIndex.this.compareNodes(rDFNode, rDFNode2 = statement2.predicate());
                if (n != 0) {
                    return n;
                }
                if (statement2.subject() == FindIndex.this.MAX_RES) {
                    return -1;
                }
                if (statement.subject() == FindIndex.this.MAX_RES) {
                    return 1;
                }
                return 0;
            }
            catch (ModelException modelException) {
                return 0;
            }
        }

        public boolean equals(Object object) {
            return object instanceof OPComparator;
        }
    }

    private class PrefixIterator
    implements Iterator {
        Iterator it;
        int maxIt;
        Object n;
        Iterator setIt;
        Comparator comparator;

        public PrefixIterator(Statement statement, SortedMap sortedMap) throws ModelException {
            this.comparator = sortedMap.comparator();
            if (statement.subject() != null && statement.predicate() != null && statement.object() != null) {
                this.maxIt = 1;
                this.it = sortedMap.tailMap(statement).values().iterator();
            } else {
                this.maxIt = Integer.MAX_VALUE;
                StatementImpl statementImpl = new StatementImpl(FindIndex.this.limitResource(statement.subject()), FindIndex.this.limitResource(statement.predicate()), FindIndex.this.limitNode(statement.object()));
                this.it = sortedMap.subMap(statement, statementImpl).values().iterator();
            }
            this.step();
        }

        public boolean hasNext() {
            return this.n != null;
        }

        public Object next() {
            if (this.n == null) {
                throw new NoSuchElementException();
            }
            Object object = this.n;
            this.n = null;
            this.step();
            return object;
        }

        public void remove() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void step() {
            this.n = null;
            if (this.setIt == null || !this.setIt.hasNext()) {
                if (!this.it.hasNext() || this.maxIt <= 0) return;
                Object e = this.it.next();
                --this.maxIt;
                if (FindIndex.this.DEBUG) {
                    System.err.println("-- main it next: " + e);
                }
                if (e instanceof Statement) {
                    this.n = e;
                    return;
                } else {
                    if (!(e instanceof Set)) throw new ClassCastException("Invalid entry " + e + ", must be set or statement");
                    this.setIt = ((Set)e).iterator();
                    this.n = this.setIt.next();
                    if (!FindIndex.this.DEBUG) return;
                    System.err.println("-- set it next 1: " + this.n);
                }
                return;
            } else {
                this.n = this.setIt.next();
                if (!FindIndex.this.DEBUG) return;
                System.err.println("-- set it next 2: " + this.n);
            }
        }
    }
}

