/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.rdf.util;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.InputSource;

public class RDFReader
extends FilterReader {
    StringBuffer nsbuf = new StringBuffer();
    int nsbufPos;
    StringBuffer buf = new StringBuffer();
    int bufPos;
    boolean done;
    String delimiter;
    int delimiterPos;
    static final int INITIAL = 0;
    static final int PASS = 1;
    static final int LT_EXPECTED = 2;
    static final int IN_RDF = 3;
    int state = 0;

    public RDFReader(Reader reader) {
        super(reader);
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
    }

    public void close() throws IOException {
    }

    public static InputSource filter(InputSource inputSource) {
        Reader reader;
        InputSource inputSource2 = new InputSource();
        inputSource2.setSystemId(inputSource.getSystemId());
        inputSource2.setPublicId(inputSource.getPublicId());
        inputSource2.setEncoding(inputSource.getEncoding());
        InputStream inputStream = inputSource.getByteStream();
        Reader reader2 = reader = inputStream != null ? new InputStreamReader(inputStream) : inputSource.getCharacterStream();
        if (!(reader instanceof RDFReader)) {
            if (!reader.markSupported()) {
                reader = new BufferedReader(reader);
            }
            reader = new RDFReader(reader);
        }
        inputSource2.setCharacterStream(reader);
        return inputSource2;
    }

    boolean isNameChar(char c) {
        return Character.isLetterOrDigit(c) | c == '.' | c == '-' | c == '_' | c == ':';
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length == 0) {
            System.err.println("Usage: org.w3c.rdf.RDFReader <URI>");
            System.exit(1);
        }
        RDFReader rDFReader = new RDFReader(new BufferedReader(new InputStreamReader(new URL(stringArray[0]).openStream())));
        while ((n = ((Reader)rDFReader).read()) != -1) {
            System.out.print((char)n);
        }
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public int read() throws IOException {
        if (this.done) {
            return -1;
        }
        if (this.bufPos < this.buf.length()) {
            return this.buf.charAt(this.bufPos++);
        }
        if (this.state == 0) {
            this.in.mark(3);
            var1_1 = (char)this.in.read();
            var2_2 = (char)this.in.read();
            var3_4 = (char)this.in.read();
            this.state = var1_1 == '<' && var2_2 == '?' && var3_4 == 'x' ? 1 : 2;
            this.in.reset();
        }
        if (this.state != 1) ** GOTO lbl28
        return this.in.read();
lbl-1000:
        // 1 sources

        {
            var1_1 = this.readIt();
            if (var1_1 != '<') continue;
            this.nsbuf.setLength(0);
            while (this.isNameChar(var1_1 = this.readIt())) {
                this.nsbuf.append(var1_1);
            }
            var2_3 = this.nsbuf.toString();
            if (!var2_3.endsWith("RDF")) continue;
            this.setCache(String.valueOf(var2_3) + var1_1);
            this.state = 3;
            this.delimiter = "</" + var2_3 + ">";
            this.delimiterPos = 0;
            return 60;
lbl28:
            // 3 sources

            ** while (!this.done && this.state == 2)
        }
lbl29:
        // 1 sources

        if (!this.done && this.state == 3) {
            var1_1 = this.readIt();
            if (this.delimiterPos < this.delimiter.length()) {
                this.delimiterPos = var1_1 == this.delimiter.charAt(this.delimiterPos) ? ++this.delimiterPos : 0;
            }
            if (this.delimiterPos == this.delimiter.length()) {
                this.state = 2;
            }
            return var1_1;
        }
        return -1;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.read();
            if (n4 < 0) {
                return n3 > 0 ? n3 : -1;
            }
            cArray[n + n3++] = (char)n4;
            --n2;
        }
        return n3;
    }

    char readIt() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            this.done = true;
        }
        return (char)n;
    }

    public boolean ready() throws IOException {
        if (this.done) {
            return false;
        }
        if (this.bufPos < this.buf.length()) {
            return true;
        }
        int n = this.read();
        if (!this.done) {
            this.setCache(n);
            return true;
        }
        return false;
    }

    void setCache(int n) {
        this.buf.setLength(0);
        this.bufPos = 0;
        this.buf.append((char)n);
    }

    void setCache(String string) {
        this.buf.setLength(0);
        this.bufPos = 0;
        this.buf.append(string);
    }
}

