/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Transaction;
import edu.stanford.smi.protege.test.APITestCase;

public class Transaction_Test
extends APITestCase {
    public void setUp() throws Exception {
        super.setUp();
        Transaction_Test.chooseDBType();
        Transaction_Test.setDatabaseProject();
    }

    public void testCommit() {
        int n = this.getFrameCount();
        Transaction transaction = new Transaction(this.getDomainKB()){

            public boolean doOperations() {
                KnowledgeBase knowledgeBase = this.getKnowledgeBase();
                Cls cls = knowledgeBase.createCls(null, knowledgeBase.getRootClses());
                knowledgeBase.createInstance(null, cls);
                return true;
            }
        };
        boolean bl = transaction.execute();
        Transaction_Test.assertTrue((String)"transaction succeeded", (boolean)bl);
        Transaction_Test.assertEquals((String)"frame count in cache", (int)(n + 2), (int)this.getFrameCount());
        Transaction_Test.saveAndReload();
        Transaction_Test.assertEquals((String)"frame count in database", (int)(n + 2), (int)this.getFrameCount());
    }

    public void testRollback() {
        String string = this.createCls().getName();
        int n = this.getFrameCount();
        Transaction transaction = new Transaction(this.getDomainKB()){

            public boolean doOperations() {
                KnowledgeBase knowledgeBase = this.getKnowledgeBase();
                Cls cls = knowledgeBase.createCls(null, knowledgeBase.getRootClses());
                knowledgeBase.createInstance(null, cls);
                return false;
            }
        };
        boolean bl = transaction.execute();
        Transaction_Test.assertTrue((String)"transaction rolled back", (!bl ? 1 : 0) != 0);
        Transaction_Test.assertEquals((String)"frame count in cache", (int)n, (int)this.getFrameCount());
        Transaction_Test.saveAndReload();
        Transaction_Test.assertEquals((String)"frame count in database", (int)n, (int)this.getFrameCount());
        Cls cls = this.getCls(string);
        Transaction_Test.assertNotNull((String)"class", (Object)cls);
        this.createInstance(cls);
    }
}

