/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGeneratorFrameStore
extends ModificationFrameStore {
    private List _events = new ArrayList();
    private static final int NO_VALUE = -1;
    private int _transactionStartSize = -1;
    private DefaultKnowledgeBase _kb;
    private SystemFrames _systemFrames;
    private boolean generateEventsOnDeletingFrames = false;

    public EventGeneratorFrameStore(KnowledgeBase knowledgeBase) {
        this._kb = (DefaultKnowledgeBase)knowledgeBase;
        this._systemFrames = this._kb.getSystemFrames();
    }

    @Override
    public void reinitialize() {
        this._events.clear();
        this.resetTransactionStartSize();
    }

    @Override
    public void close() {
        super.close();
        this._events.clear();
        this._events = null;
        this._kb = null;
        this._systemFrames = null;
    }

    @Override
    public Frame getFrame(String string) {
        return this.getDelegate().getFrame(string);
    }

    @Override
    public Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        Cls cls = this.getDelegate().createCls(frameID, string, collection, collection2, bl);
        this.generateCreateClsEvents(cls, collection);
        return cls;
    }

    @Override
    public Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        Slot slot = this.getDelegate().createSlot(frameID, string, collection, collection2, bl);
        this.generateCreateSlotEvents(slot, collection);
        return slot;
    }

    @Override
    public Facet createFacet(FrameID frameID, String string, Collection collection, boolean bl) {
        Facet facet = this.getDelegate().createFacet(frameID, string, collection, bl);
        this.generateCreateFacetEvents(facet, collection);
        return facet;
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.generateSetDirectOwnSlotValuesEvents(frame, slot, collection);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, collection);
    }

    private void generateSetFrameNameEvents(Frame frame, String string, String string2) {
        this.generateFrameEvent(101, frame, string);
        this.generateFrameEvent(105, frame);
        this.generateFrameEvent(110, frame, this._systemFrames.getNameSlot());
        this.generateKbEvent(101, frame, string);
    }

    private void generateSetDirectOwnSlotValuesEvents(Frame frame, Slot slot, Collection collection) {
        this.generateOwnSlotValuesChangedEvent(frame, slot);
        this.generateFrameEvent(105, frame);
        Slot slot2 = (Slot)CollectionUtilities.getFirstItem(this.getDirectOwnSlotValues(slot, this._systemFrames.getInverseSlotSlot()));
        if (slot2 != null) {
            List list = this.getDirectOwnSlotValues(frame, slot);
            for (Frame frame2 : collection) {
                if (list.contains(frame2)) continue;
                this.generateFrameEvent(110, frame2, slot2);
            }
            for (Frame frame2 : list) {
                if (collection.contains(frame2)) continue;
                this.generateFrameEvent(110, frame2, slot2);
            }
        }
    }

    private void generateDeleteFrameKbEvent(int n, Frame frame) {
        this.generateKbEvent(n, frame, frame.getName());
    }

    private void generateDeleteClsEvents(Cls cls) {
        this.generateDeleteFrameKbEvent(602, cls);
        for (Cls cls2 : this.getDirectSuperclasses(cls)) {
            this.generateClsEvent(304, cls2, cls);
        }
        this.generateDeleteInstanceEvents(cls);
    }

    private void generateDeleteSimpleInstanceEvents(SimpleInstance simpleInstance) {
        this.generateDeleteFrameKbEvent(608, simpleInstance);
        this.generateDeleteInstanceEvents(simpleInstance);
    }

    private void generateDeleteSlotEvents(Slot slot) {
        this.generateDeleteFrameKbEvent(604, slot);
        this.generateDeleteInstanceEvents(slot);
    }

    private void generateDeleteFacetEvents(Facet facet) {
        this.generateDeleteFrameKbEvent(606, facet);
        this.generateDeleteInstanceEvents(facet);
    }

    private void generateDeleteInstanceEvents(Instance instance) {
        this.generateRemoveDirectInstanceEvents(instance);
        for (Reference reference : this.getReferences(instance)) {
            this.removeReference(reference, instance);
        }
        this.generateFrameEvent(102, instance, instance.getName());
    }

    private void generateRemoveDirectInstanceEvents(Instance instance) {
        for (Cls cls : this.getDirectTypes(instance)) {
            this.generateClsEvent(306, cls, instance);
        }
    }

    private void removeReference(Reference reference, Instance instance) {
        Frame frame = reference.getFrame();
        Slot slot = reference.getSlot();
        Facet facet = reference.getFacet();
        boolean bl = reference.isTemplate();
        this.removeReference(frame, slot, facet, bl, instance);
    }

    private void removeReference(Frame frame, Slot slot, Facet facet, boolean bl, Instance instance) {
        if (facet == null) {
            if (bl) {
                this.removeTemplateSlotValueReference(frame, slot, instance);
            } else {
                this.removeOwnSlotValueReference(frame, slot, instance);
            }
        } else if (bl) {
            this.removeTemplateFacetValueReference(frame, slot, facet, instance);
        }
    }

    private void removeOwnSlotValueReference(Frame frame, Slot slot, Instance instance) {
        this.generateFrameEvent(110, frame, slot);
    }

    private void removeTemplateSlotValueReference(Frame frame, Slot slot, Instance instance) {
    }

    private void removeTemplateFacetValueReference(Frame frame, Slot slot, Facet facet, Instance instance) {
    }

    @Override
    public void deleteCls(Cls cls) {
        this.generateDeleteClsEvents(cls);
        this.getDelegate().deleteCls(cls);
    }

    @Override
    public void deleteSlot(Slot slot) {
        this.generateDeleteSlotEvents(slot);
        this.getDelegate().deleteSlot(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        this.generateDeleteFacetEvents(facet);
        this.getDelegate().deleteFacet(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.generateDeleteSimpleInstanceEvents(simpleInstance);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(frameID, string, collection, bl);
        this.generateCreateSimpleInstanceEvents(simpleInstance, collection);
        return simpleInstance;
    }

    private void generateCreateClsEvents(Cls cls, Collection collection) {
        this.generateCreateInstanceEvents(601, cls, collection);
        for (Cls cls2 : cls.getDirectSuperclasses()) {
            this.generateClsEvent(303, cls2, cls);
            this.generateOwnSlotValuesChangedEvent(cls2, this._systemFrames.getDirectSubclassesSlot());
        }
    }

    private void generateCreateFacetEvents(Facet facet, Collection collection) {
        this.generateCreateInstanceEvents(605, facet, collection);
    }

    private void generateCreateSlotEvents(Slot slot, Collection collection) {
        this.generateCreateInstanceEvents(603, slot, collection);
        for (Slot slot2 : slot.getDirectSuperslots()) {
            this.generateSlotEvent(405, slot2, slot);
            this.generateOwnSlotValuesChangedEvent(slot2, this._systemFrames.getDirectSubslotsSlot());
        }
    }

    private void generateCreateSimpleInstanceEvents(SimpleInstance simpleInstance, Collection collection) {
        this.generateCreateInstanceEvents(607, simpleInstance, collection);
    }

    private void generateCreateInstanceEvents(int n, Frame frame, Collection collection) {
        this.generateKbEvent(n, frame);
        for (Cls cls : collection) {
            this.generateClsEvent(305, cls, frame);
            this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectInstancesSlot());
        }
    }

    private void generateKbEvent(int n, Frame frame) {
        this._events.add(new KnowledgeBaseEvent(this._kb, n, frame));
    }

    private void generateKbEvent(int n, Frame frame, String string) {
        this._events.add(new KnowledgeBaseEvent(this._kb, n, frame, (Object)string));
    }

    private boolean generateEvent(Frame frame) {
        return !frame.isBeingDeleted() || this.generateEventsOnDeletingFrames;
    }

    private void generateFrameEvent(int n, Frame frame) {
        this.generateFrameEvent(n, frame, null, null);
    }

    private void generateFrameEvent(int n, Frame frame, Object object) {
        this.generateFrameEvent(n, frame, object, null);
    }

    private void generateFrameEvent(int n, Frame frame, Object object, Object object2) {
        if (this.generateEvent(frame)) {
            this._events.add(new FrameEvent(frame, n, object, object2));
        }
    }

    private void generateClsEvent(int n, Cls cls, Frame frame, Frame frame2) {
        if (this.generateEvent(cls)) {
            this._events.add(new ClsEvent(cls, n, (Object)frame, (Object)frame2));
        }
    }

    private void generateClsEvent(int n, Cls cls, Frame frame) {
        this.generateClsEvent(n, cls, frame, null);
    }

    private void generateSlotEvent(int n, Slot slot, Frame frame) {
        if (this.generateEvent(slot)) {
            this._events.add(new SlotEvent(slot, n, frame));
        }
    }

    private void generateInstanceEvent(int n, Instance instance, Frame frame) {
        if (this.generateEvent(instance)) {
            this._events.add(new InstanceEvent(instance, n, (Object)frame));
        }
    }

    @Override
    public List<EventObject> getEvents() {
        if (!this.isInTransaction()) {
            List list = this._events;
            this._events = new ArrayList();
            return list;
        }
        List list = Collections.EMPTY_LIST;
        return list;
    }

    private boolean isInTransaction() {
        return this._transactionStartSize != -1;
    }

    private void resetTransactionStartSize() {
        this._transactionStartSize = -1;
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls cls2) {
        Collection collection = this.getSlotsToBeAdded(cls, cls2);
        this.getDelegate().addDirectSuperclass(cls, cls2);
        this.generateClsEvent(301, cls, cls2);
        this.generateClsEvent(303, cls2, cls);
        this.generateSuperclassTemplateSlotChangedEvents(cls, 308, collection);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, cls2, this._systemFrames.getDirectSuperclassesSlot());
    }

    private Collection getSlotsToBeAdded(Cls cls, Cls cls2) {
        HashSet hashSet = new HashSet(this.getTemplateSlots(cls2));
        hashSet.removeAll(this.getTemplateSlots(cls));
        return hashSet;
    }

    private void generateSuperclassTemplateSlotChangedEvents(Cls cls, int n, Collection collection) {
        for (Slot slot : collection) {
            this.generateClsEvent(n, cls, slot);
        }
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Frame frame2, Slot slot) {
        this.generateOwnSlotValuesChangedEvent(frame, slot);
        this.generateOwnSlotValuesChangedEvent(frame2, slot.getInverseSlot());
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Slot slot) {
        ArrayList arrayList = null;
        if (this.getValues(frame, slot)) {
            arrayList = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
        }
        this.generateOwnSlotValuesChangedEvent(frame, slot, arrayList);
    }

    private boolean getValues(Frame frame, Slot slot) {
        return !slot.equals(this._systemFrames.getDirectSubclassesSlot()) && !slot.equals(this._systemFrames.getDirectInstancesSlot());
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Slot slot, Collection collection) {
        this.generateFrameEvent(110, frame, slot, collection);
        for (Slot slot2 : slot.getSuperslots()) {
            this.generateFrameEvent(110, frame, slot2, collection);
        }
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        HashSet<Slot> hashSet = new HashSet<Slot>(cls.getTemplateSlots());
        this.getDelegate().removeDirectSuperclass(cls, cls2);
        hashSet.removeAll(cls.getTemplateSlots());
        this.generateClsEvent(302, cls, cls2);
        this.generateClsEvent(304, cls2, cls);
        this.generateSuperclassTemplateSlotChangedEvents(cls, 309, hashSet);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, cls2, this._systemFrames.getDirectSuperclassesSlot());
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, n, n2);
        this.generateOwnSlotValuesChangedEvent(frame, slot);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        this.getDelegate().moveDirectSubclass(cls, cls2, n);
        this.generateClsEvent(307, cls, cls2);
        this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        this.getDelegate().moveDirectSubslot(slot, slot2, n);
        this.generateSlotEvent(409, slot, slot2);
        this.generateOwnSlotValuesChangedEvent(slot, this._systemFrames.getDirectSubslotsSlot());
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot slot2) {
        this.getDelegate().addDirectSuperslot(slot, slot2);
        this.generateSlotEvent(407, slot, slot2);
        this.generateSlotEvent(405, slot2, slot);
        this.generateOwnSlotValuesChangedEvent((Frame)slot, (Frame)slot2, this._systemFrames.getDirectSuperslotsSlot());
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        this.getDelegate().removeDirectSuperslot(slot, slot2);
        this.generateSlotEvent(408, slot, slot2);
        this.generateSlotEvent(406, slot2, slot);
        this.generateOwnSlotValuesChangedEvent((Frame)slot, (Frame)slot2, this._systemFrames.getDirectSuperslotsSlot());
    }

    @Override
    public void addDirectType(Instance instance, Cls cls) {
        this.getDelegate().addDirectType(instance, cls);
        this.generateInstanceEvent(202, instance, cls);
        this.generateClsEvent(305, cls, instance);
        this.generateOwnSlotValuesChangedEvent((Frame)instance, cls, this._systemFrames.getDirectTypesSlot());
    }

    @Override
    public void removeDirectType(Instance instance, Cls cls) {
        this.getDelegate().removeDirectType(instance, cls);
        this.generateInstanceEvent(203, instance, cls);
        this.generateClsEvent(306, cls, instance);
        this.generateOwnSlotValuesChangedEvent((Frame)instance, cls, this._systemFrames.getDirectTypesSlot());
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int n) {
        this.getDelegate().moveDirectType(instance, cls, n);
        this.generateOwnSlotValuesChangedEvent(instance, this._systemFrames.getDirectTypesSlot());
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.generateClsEvent(308, cls, slot);
        this.generateSlotEvent(401, slot, cls);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, (Frame)slot, this._systemFrames.getDirectTemplateSlotsSlot());
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.generateClsEvent(309, cls, slot);
        this.generateSlotEvent(402, slot, cls);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, (Frame)slot, this._systemFrames.getDirectTemplateSlotsSlot());
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        this.getDelegate().moveDirectTemplateSlot(cls, slot, n);
        this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectTemplateSlotsSlot());
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, collection);
        this.generateClsEvent(310, cls, slot);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection);
        this.generateClsEvent(313, cls, slot, facet);
    }

    @Override
    public void setFrameName(Frame frame, String string) {
        String string2 = this.getDelegate().getFrameName(frame);
        this.getDelegate().setFrameName(frame, string);
        this.generateSetFrameNameEvents(frame, string2, string);
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            this.generateClsEvent(313, cls, slot, facet);
        }
    }

    @Override
    public boolean beginTransaction(String string) {
        boolean bl = this.getDelegate().beginTransaction(string);
        this.generateTransactionEvent(701, string);
        if (bl && !this.isInTransaction()) {
            this._transactionStartSize = this._events.size();
        }
        return bl;
    }

    private void generateTransactionEvent(int n, String string) {
        this._events.add(new TransactionEvent(this._kb, n, string));
    }

    @Override
    public boolean commitTransaction() {
        boolean bl = this.getDelegate().commitTransaction();
        if (!bl && this.isInTransaction()) {
            this._events.subList(this._transactionStartSize, this._events.size()).clear();
        }
        this.generateTransactionEvent(702, null);
        this.resetTransactionStartSize();
        return bl;
    }

    @Override
    public boolean rollbackTransaction() {
        boolean bl = this.getDelegate().rollbackTransaction();
        if (bl && this.isInTransaction()) {
            this._events.subList(this._transactionStartSize, this._events.size()).clear();
        }
        this.generateTransactionEvent(702, null);
        this.resetTransactionStartSize();
        return bl;
    }

    public boolean setDeletingFrameEventsEnabled(boolean bl) {
        boolean bl2 = this.generateEventsOnDeletingFrames;
        this.generateEventsOnDeletingFrames = bl;
        return bl2;
    }
}

